﻿!--------------------------------------------------------------------
! Declare Kolya's parameters
!--------------------------------------------------------------------
      MODULE Kolya_parameters
      IMPLICIT NONE ; SAVE
      integer                       :: Mdelta  ! number of delta-functions
      integer                       :: Mwmax   ! number of frequency points
      integer                       :: Nt      ! number of tau points

      double precision, allocatable :: ogrid(:)  ! frequency points
      double precision, allocatable :: dom(:)    ! delta frequency points
      double precision, allocatable :: go(:)     ! spectral amplitudes
      double precision, allocatable :: oint(:,:) ! (omega,t) kernel
      double precision, allocatable :: gosave(:) ! save configuration
      DOUBLE PRECISION, ALLOCATABLE :: gonsave(:)

      double precision, allocatable :: tgrid(:)        ! tau points
      double precision, allocatable :: gt(:), sigma_K(:) ! tau-function error
      double precision              :: errscale        ! auxiliary errors scaling
      double precision              :: errorscale0
      double precision, allocatable :: Tfactor(:)    ! penalty from errorbars
      double precision, allocatable :: Dfactor(:)    ! penalty for derivative
      double precision, allocatable :: Afactor(:)    ! penalty for negative
      double precision, allocatable :: D4factor(:,:) ! penalty for non-linear
      double precision, allocatable :: D2factor(:)   ! penalty for 2d-derivative
      double precision              :: Ymax, Ymin, Yscale       ! bounds
      double precision, parameter   :: Dmax=1.d06   ! bound
      double precision              :: Dmin
      double precision              :: Dscale, D4scale
      double precision, parameter   :: background=0.0d0         ! bounds

      double precision              :: objectiveT      ! chi2

      double precision              :: obj1, obj2      ! objectives,
      double precision              :: der
      double precision :: Nor_ma,Nfactor
      double precision, allocatable :: N_int(:)

      double precision, allocatable :: AA(:,:), AAT(:,:)  ! matrix
      double precision, allocatable :: BB(:), BBT(:)      ! vector
      double precision              :: DD, DDT            ! constant

      integer :: iter1 , iter2    ! counters
      integer :: iterstop, iterstop2
      integer :: it, io, ioo                 ! loop counters
      DOUBLE PRECISION   :: objectiveT0, levelstep, objbest


      double precision :: norm,x,y,z,w

      END MODULE Kolya_parameters
!....................................................................


!--------------------------------------------------------------------
! Declare useful parameters
!--------------------------------------------------------------------
      MODULE useful_parameters
      IMPLICIT NONE ; SAVE
! Limiting parameters
      INTEGER,PARAMETER :: many_times=100000000  ! almost infinite loop
      INTEGER,PARAMETER :: max_run=10100  ! max number of runs
      INTEGER,PARAMETER :: max_att=50        ! max attempts to set precision
! Fixed dimensions limiting parameters
      INTEGER,PARAMETER :: time_po=5001
      INTEGER,PARAMETER :: frec_num=5001
! Just counters
      INTEGER :: i,j,l
! Exponent cutoff
      REAL*8,PARAMETER  :: ex_ma=650.0d0
      REAL*8,PARAMETER ::  big=1.956199921370272D+282           !ExponentPa
      REAL*8,PARAMETER ::  sma=5.111951948651156D-283       !ExponentPar
      REAL*8,PARAMETER :: dopusk=1.0d-10
! constants
      REAL*8,PARAMETER  :: pi=3.1415927d0
      REAL*8,PARAMETER  :: zero=0.0d0,un1=1.0d0,un2=2.0d0
      REAL*8,PARAMETER  :: un3=3.0d0,un4=4.0d0
      REAL*8,PARAMETER  :: min_den=1.0d-150
      REAL*8,PARAMETER  :: more_than_one=2.0
      REAL*8,PARAMETER  :: small_jump=1.0d-100
! empty variables
      REAL*8               :: void  ! empty variable
      INTEGER              :: ivoid ! empty variable
      INTEGER,PARAMETER :: sboi=100              !dephasing of RNG
!  debugging parameters
      LOGICAL,PARAMETER :: todo=.FALSE. !check configuration on every step if TRUE
                                                              !BEWARE! SLOWDOWN THE CODE!
      LOGICAL,PARAMETER :: skip=.TRUE.  !check configuration on every step if TRUE
                                                              !BEWARE! SLOWDOWN THE CODE!
      LOGICAL,PARAMETER :: print_additional=.TRUE.
      LOGICAL,PARAMETER :: print_control=.TRUE.
      REAL*8 :: KakaShiki ! counter for NAN in objective in CCtransform
      END MODULE useful_parameters
!....................................................................

!--------------------------------------------------------------------
! Declare time-dependent variables
!--------------------------------------------------------------------
      MODULE time_data
      USE useful_parameters
      IMPLICIT NONE ; SAVE
      INTEGER                   :: nt      ! Number of time points
      INTEGER                   :: n_all, n_beg, n_end ! Usage of points for kernel=2
      INTEGER                   :: nt_d2 ! Half of complex time points
      INTEGER                   :: nt_compl, nt_imag ! NUmber of complex and imaginry time points
      INTEGER                   :: complex_include,imaginary_include !Points left for analysis
! input variables for imaginary time representation
      REAL*8,DIMENSION(time_po) :: gr,ta,sigma ! GF, time, err_bar-relative
      REAL*8,DIMENSION(time_po) :: gr_uk, ta_uk, sigma_uk ! For kernel=2
      REAL*8,DIMENSION(time_po) :: gubar,sigmar,tagar
! input variables for Matsubara representation
      COMPLEX*16,DIMENSION(time_po) :: G_input, Om_input
!ComplexGF&MatsGFrec
      REAL*8,DIMENSION(time_po) :: G_inp_re,G_inp_im,Om_inp_re
!  Nikolay data
      REAL*8,DIMENSION(time_po,frec_num) :: Ka_Kol   !Kernel for Kolya
      COMPLEX*16,DIMENSION(time_po,frec_num) :: Ka_Kol_MA!Kernel for Kolya
      END MODULE time_data
!....................................................................

!--------------------------------------------------------------------
! Declare variables for float configuration for free spectrum
!--------------------------------------------------------------------
      MODULE float_configuration
      USE useful_parameters; IMPLICIT NONE ; SAVE
      REAL*8                    :: kurik           ! Best normalization
      REAL*8 :: chuki_do,chuki_po           ! Check for advancing of deviation
! free spectrum configuration =====================
      REAL*8                    :: anorma_0        ! total normalisation
      INTEGER :: nmnm
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_0,ro_h0,to_t0
      REAL*8                    :: om_anz_0,z_anz_0
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_le,om_ri
!LeftRightForZeroHeight
! deviation for these parameters
      REAL*8                    :: buli
      REAL*8                    :: buli_inrun
!---------------------------------------------------------------------------
! best free spectrum configuration =====================
      REAL*8                    :: anorma_b        ! total normalisation
      INTEGER                   :: nmnmb
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_b,ro_hb,to_tb
      REAL*8                    :: om_anz_b,z_anz_b
! best deviation
      REAL*8                    :: z_best
!-------------------------------------------------------
! spectrum configuration for saving =====================
      REAL*8                    :: anorma_sav        ! total normalisation
      INTEGER                   :: nmnm_sav
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_0_sav,ro_h_sav,to_t_sav
      REAL*8                    :: om_anz_sav,z_anz_sav
! best deviation
      REAL*8                    :: z_best_sav
!--------------------------------------------------------
      REAL*8                    :: z_b_old         ! Deviation before global update
!-------------------------------------------------------
! shuffled spectrum configuration 1 ==========================
      REAL*8                    :: anorma_sh        ! total normalisation
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_sh,ro_h_sh,to_t_sh
      INTEGER                   :: nmnm_sh
! deviation for these parameters
      REAL*8                    :: buli_sh
! shuffled spectrum configuration 2 ==========================
      REAL*8                    :: anorma_sh2        ! total normalisation
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_sh2,ro_h_sh2,to_t_sh2
      INTEGER                   :: nmnm_sh2
! deviation for these parameters
      REAL*8                    :: buli_sh2
!! Scratch configurations
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_1,ro_h1,to_t1
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_2,ro_h2,to_t2
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_3,ro_h3,to_t3
! Nikolay's configuration ==========================
      REAL*8,DIMENSION(frec_num) :: N_om_0,N_ro_h0,N_to_t0
      REAL*8,DIMENSION(frec_num) :: N_om_le,N_om_ri
!LeftRightForZeroHeight
      INTEGER                   :: N_nmnm
      END MODULE float_configuration
!....................................................................

!--------------------------------------------------------------------
! Declare parameters for governing the process
!--------------------------------------------------------------------
      MODULE proc_par
      USE useful_parameters ; IMPLICIT NONE ; SAVE
!
      LOGICAL :: skip_further
!
      INTEGER,PARAMETER :: n_cikl0=500  !MaxNumbOfCiclesForGlobalRun
      INTEGER :: n_cikl !CurrentGlobalRun
      INTEGER,PARAMETER :: min_in_fr=30, max_in_fr=10
!(Min/Mac)InitNumOfFreq
      INTEGER,PARAMETER :: i_test_proc=0 !TestinSubroutine(If /=0)
!
      REAL*8,PARAMETER :: afemin=3.0d-1, afemax=3.0d+1, trah=7.0d0
!ToReduceJumpsBack
      REAL*8,PARAMETER :: alt_pr=0.2d-0,mi_ra=0.0d0,ma_ra=8.0d+1
!BIRDTH/DEATHballance
      REAL*8,PARAMETER :: capu_min=1.0d-4, capu_max=1.01d0
!ForJumpScalingManager
      REAL*8,PARAMETER :: stewi=2.00000001
!ContextForWidthChangesOfFrequency
      REAL*8,PARAMETER :: purki=1.0d-5 !ConfinementForBirdthAlmostEqualFreq
      REAL*8,PARAMETER :: sgw=1.0d-4, sgw_abs=sgw
!Relative&AbsoluteMaxFrecWidth
      REAL*8,PARAMETER :: ato=1.0d-4
!RealtiveMinTotalForOneFreqInFractionOfNorma
      REAL*8 :: ato_abs !RealtiveMinTotalForOneFreqInFractionOfNorma
!
      REAL*8 :: norm_fr_che !norm_min - z_anz_max
      REAL*8 :: min_height !MinHeightOfFrequency
! whole process data
      REAL*8,DIMENSION(3) :: proc0, aduva  !Birdth/Deth/Alter probabilities
! one loop data
      REAL*8  :: afe_glo !ReduceJumpBackForGlobUpdate
      REAL*8  :: afe       !ReduceJumpBackForStep
      REAL*8  :: capur    !ParameterForJumpScalingManager
      REAL*8  :: batura   !Z-exchange between free and anzac weight
      END MODULE proc_par
!....................................................................

!--------------------------------------------------------------------
! Declare variables for global control
!--------------------------------------------------------------------
      MODULE global_control
      USE useful_parameters ; IMPLICIT NONE ; SAVE
! Allow processes
      LOGICAL :: do_shi_full, do_ex_z, do_wid_ch, do_shi_two
      LOGICAL :: do_shi_anz1, do_ex_z_anz1
      LOGICAL :: do_spl_born
      LOGICAL :: do_glue
! Anzaces
      LOGICAL :: yes_anzac
      INTEGER :: NACALO_free
      REAL*8,DIMENSION(100) :: start_Nikolay
      INTEGER :: ista_Nikolay,N_Nikolay
! MaxHeight
      REAL*8,PARAMETER :: maxi_height_0=1.0d+10
      REAL*8 :: maxi_height,gmax
!
      INTEGER           :: k                !random number generator parameter
      INTEGER           :: initial_k       !initial random number for attempt
! Time mesh data
      REAL*8,ALLOCATABLE,DIMENSION(:)     :: gc           ! calculated green function
      REAL*8,ALLOCATABLE,DIMENSION(:)     :: gc_global    ! calculated green function
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: gc_at
      REAL*8,ALLOCATABLE,DIMENSION(:) :: deviation,deviation_im,deviation_imatau
      REAL*8,ALLOCATABLE,DIMENSION(:) :: deviation_glob
! Matsubara mesh data
      COMPLEX*16,ALLOCATABLE,DIMENSION(:)     :: gc_MA           ! calculated green function
      COMPLEX*16,ALLOCATABLE,DIMENSION(:)     :: gc_global_MA    ! calculated green function
      COMPLEX*16,ALLOCATABLE,DIMENSION(:,:) :: gc_at_MA

      INTEGER,DIMENSION(2) :: chf1,chf2

      REAL*8 :: zaludil ! counter for addressing CCtransform
      REAL*8,DIMENSION(100) :: nastupil, poluchil ! counters for calling CCtransform
! Histogram data
      REAL*8 :: sh_his, sh_his_big, sh_his_hei
!HistStep,HistStepBoig,StepForHeight
      REAL*8,ALLOCATABLE,DIMENSION(:) :: &
                                 om_grid,       hi_flo,hi_glob, &
                                                     hi_flo_kol, &
                                 om_grid_big, hi_flo_big,hi_glob_big, &
                                 om_grid_hei, hi_flo_hei
!Process control
      CHARACTER(40) :: char ! service dimension
      REAL*8 :: max_deviation,ave_deviation !Fit parameters
      INTEGER :: i_glo_performed = 0            !NumOfPerformedGlobalRuns
      INTEGER :: i_glo_run = 0            !NumOfPerformedAttempts
      INTEGER :: i_loc_run = 0                       !AttemptsCounter
      INTEGER :: i_glo_suc = 0
!NumOfSuccesfullAttempta
      LOGICAL :: starting_procedure     !Starting adjust, if true
      REAL*8,DIMENSION(max_att,8)  :: co_of         ! service dimension
      REAL*8,DIMENSION(max_run,8)  :: po_of,cpo_of         ! service dimension
      INTEGER,DIMENSION(max_att)    :: ng_of   ! service dimension
      INTEGER,DIMENSION(max_run)    :: nm_of,cnm_of   ! service dimension
      REAL*8 :: kappa !Fraction of intersection in deviation
! Heigth control
      REAL*8 :: buzi
! Records control
      INTEGER ::conf_old,conf_new,conf_init
!RecordLengthForCongigurationRecord
      INTEGER :: rec_len,rec_len_big  !RecordLengthForHistogramsRecord
! Effectivity parameters
      REAL*8 :: duha_all=0, duha_bad=0, duha_chu=0            !Succe cickles
      REAL*8 :: duha_nor=0, duha_ran=0                        !Succe cickles
      REAL*8 :: duha_num                                             !Succe cickles  
! Vertical slicing parameters
      REAL*8 ::ravno=0, null=0, ravno2=0           !Vertical slicing
      REAL*8 :: co_ver=0  ,co_ver1=0 ,c_ver=0   !Vertical slicing
      REAL*8 :: buli_fail=0  ,frec_fail=0               !Vertical slicing
      REAL*8 :: spre_count=0 ,dens_count=0        !Vertical slicing
! Mixed times control
      REAL*8 :: e_es_compl, e_es_image
      REAL*8 :: object_complex, object_imaginary
      

      INTEGER :: num_stat  = 0
!NumStatHistForOneAttempt

      INTEGER:: ido_hei,ipo_hei
! Updates effectrivity counters
      INTEGER :: c_shi_full_e=0 ,c_shi_full_o=0 ,co_shi_full=0 !shi_fullcounter
      INTEGER :: c_ex_z_e=0 ,c_ex_z_o=0 ,co_ex_z=0 !shi_full counter
      INTEGER :: c_wid_ch_e=0 ,c_wid_ch_o=0 ,co_wid_ch=0 !shi_full counter
      INTEGER :: c_shi_two_e=0 ,c_shi_two_o=0 ,co_shi_two=0 !shi_fullcounter
      INTEGER :: c_spl_born_e=0 ,c_spl_born_o=0 ,co_spl_born=0 !new_borncounter
      INTEGER :: c_glue_e=0 ,c_glue_o=0 ,co_glue=0 !glue counter
      INTEGER :: c_vert_e=0 ,c_vert_o=0 ,co_vert=0 !vert slicing counter
      INTEGER :: c_shi_anz1_e=0 ,c_shi_anz1_o=0 ,co_shi_anz1=0 !new_borncounter
      INTEGER :: c_ex_anz1_e=0 ,c_ex_anz1_o=0 ,co_ex_anz1=0 !new_borncounter
      INTEGER :: co_upd=0 ,c_alt=0 ,c_bor=0, c_del=0 !types of updatecounter
      
! CC effectivity control
      INTEGER,PARAMETER :: imax_pomog=1000000
      REAL*8,DIMENSION(imax_pomog,2) :: Pomog
      INTEGER :: i_pomog=0

      END MODULE global_control
!....................................................................

!--------------------------------------------------------------------
! Declare variables for global control
!--------------------------------------------------------------------
      MODULE ext_control_data
      USE useful_parameters ; IMPLICIT NONE ; SAVE
!
      INTEGER,PARAMETER :: confi_mix=3
!
      INTEGER :: max_glo_run       !number of global runs
      INTEGER :: stat_is                 !Statistics is present (if /=0)
      INTEGER :: refinement           !Refine Data (if /=0)
      INTEGER :: superrefinement   !SuperRefine Data (if /=0)
      INTEGER :: stat_ref                !Refined statistic is present (if /=0)
      INTEGER :: write_loop            !Write Intermediate Data, (if /=0)
      REAL*8 :: norm_min, norm_max      !MinNorma,MaxNorma: initial generation
      REAL*8 :: om_min, om_max !LoverFreeSpec,UpperFreeSpec
      INTEGER :: num_his_hei  !Nuber of ranges for height restriction for refinement
      REAL*8 :: his_min, his_max  !LowHistRange,UpHistRange
      INTEGER :: num_his !HistogramGrid
      REAL*8 :: his_min_big, his_max_big !LowHistRange,UpHistRange - Big
      INTEGER :: num_his_big !HistogramGrid - Big
      INTEGER :: nf_max              !MaxNumberOfFrequencies
      INTEGER :: nf_max_rec        !MaxNumberOfFrequenciesForRecord
      INTEGER,PARAMETER :: ienlarge=5 ! nf_max_rec = ienlarge * nf_max
      INTEGER :: attempts            !NumAttenptsToFindBestDeviation
      INTEGER :: hvatit                 !MaxNumberOfLocalRunsForGlobalRun
      INTEGER :: kernel_type        !Kernel Type
      REAL*8 :: beta, phi             !InverseTemperature&Slanted angle for kernel=6
 ! Anzac_1 defining parameters
      REAL*8  :: om_anz_min,om_anz_max !MinFreqOfAnzac,MaxFreqOfAnzac
      REAL*8  :: z_anz_min,z_anz_max   !MinZfactOfAnzac,MaxZfactOfAnzac
 ! Prescicion paprameters
      REAL*8,DIMENSION(max_att)   :: prec, pre1
      REAL*8 :: scaler !Manual tuning of precision
      REAL*8  :: best_dev,stat_dev !DevToStopGlobalRun,DevToStartStatistic
      INTEGER,PARAMETER :: prec_frac=2           !FractionOfRunsForPrecisio
! Printing scip parameter
      INTEGER :: i_skip=0,num_skip ! Prints after num_skip attempts

      END MODULE ext_control_data
!....................................................................

!--------------------------------------------------------------------
! Declare variables for finite temperatures
!--------------------------------------------------------------------
      MODULE tabul_dat
      USE useful_parameters; IMPLICIT NONE; SAVE
! Parameters
      INTEGER,PARAMETER :: n_tabu=20000         !NumbOfTabPointsForOmega
      INTEGER,PARAMETER :: su_gri=100            !SuperGridForIntegartion
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: tab   !TabulatedIntegral
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_tab        !TabulatedOmega
! Calculated data
      REAL*8 :: om_max_tab,om_min_tab         !Max&MinOmegaForTab&Int
      REAL*8 :: sha_int                       !StepForIntegration
      REAL*8 :: sha_tab                       !StepForTabulation
      END MODULE tabul_dat
!....................................................................
 
      INCLUDE  "xenon02cc.f90"
      INCLUDE  "xenon02aux.f90"
      INCLUDE  "xenon02upd.f90"

!!*******************************************************************
!                  MAIN
!!*******************************************************************
      PROGRAM aa_spectral_analisis;
      USE global_control; IMPLICIT NONE

      CALL PERDUSHI            !Experimental
      CALL CONTROL_IN        !read input parameters
      CALL SET_RECORDS     !SetLimits&Records&FileFor(Super)refinement
      CALL RED_CORREL       !read correlator
      CALL SET_UPDATES     !read which updates to do
      CALL SET_PROC_PAR   !set global process parameters
      CALL TABU_KERNEL      !kernel tabulation
      CALL STA_READ   !read initial statistics, if any
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      PRINT*,"***********************************************"
      PRINT*,"             xenon_02    2015.07.28       No 1         "
      PRINT*,"***********************************************"
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      IF(starting_procedure) CALL ADJUST_PRECISION
      CALL GLOBAL_FREE
  
      END PROGRAM aa_spectral_analisis
!....................................................................
!--------------------------------------------------------------------
!  Asking different questions
!--------------------------------------------------------------------
      SUBROUTINE PERDUSHI
      IMPLICIT NONE;
      INTEGER :: iii

      PRINT*,"HUGE INTEGER and MESH : ",HUGE(iii),HUGE(iii)/1000000

      END SUBROUTINE PERDUSHI
!........................................................................... ..............

!--------------------------------------------------------------------
! Reading the control parameters for external user
! and forming necessary service numbers.
! Kernel type convention:
!     0  -  exp(-\omega \tau)
!     1  -  optical conductivity finite T
!     2  -  Fermi finite T imaginary time
!     3  -  Bose  finite T imaginary time
!     4  -  Fermi finite T Matsubara
!     5  -  Bose  finite T Matsubara
!     6  -  exp(-\omega \tau exp(i\phi)) -slanted \tau --> \tau exp(i\phi) 
!     7  -  exp(-\omega \tau exp(i\phi)) -slanted and exp(-\omega \tau) imaginary 
!--------------------------------------------------------------------
      SUBROUTINE CONTROL_IN
      USE ext_control_data; USE global_control; USE useful_parameters;
      USE time_data
      IMPLICIT NONE;

! Reading general control parameters
      OPEN(UNIT=4,FILE="control.in")
      READ(4,*)max_glo_run        !Max number of global runs
      READ(4,*)stat_is                 !Statistics is present (if /=0)
      READ(4,*)refinement           !Refine Data (if /=0)
      READ(4,*)superrefinement   !SuperRefine Data (if /=0)
      READ(4,*)stat_ref                !Refined statistic is present (if /=0)
      READ(4,*)write_loop            !Write Intermediate Data, (if /=0)
      READ(4,*)norm_min,norm_max      !MinNorma,MaxNorma
      READ(4,*)om_min,om_max, num_his_hei !LoverFreeSpec,UpperFreeSpec,HeiRestrict
      READ(4,*)his_min,his_max,num_his!LowHistRang,UppHistRang,HistGrid
      READ(4,*)his_min_big,his_max_big,num_his_big!LowHistRang,UpHistRan,HistGrid - Big
      PRINT*,"1"
      READ(4,*)nf_max                 !MaxNumberOfFrequencies
      READ(4,*)attempts               !NumAttenptsToFindBestDeviation
      READ(4,*)hvatit                 !MaxNumberOfLocalRunsForGlobalRun
      READ(4,*)kernel_type             !Kernel Type
      READ(4,*)beta, phi            !InverseTemperature&SlantedAngle
      READ(4,*)ista_Nikolay ! start Nikolay when number of frequencies >ista_Nikolay
      READ(4,*)N_Nikolay ! How many times to start Nikolay
      PRINT*,"2"
      READ(4,*)start_Nikolay(1:N_Nikolay) ! Precisions to start i-th Nikolay
      READ(4,*)complex_include,imaginary_include  !RestrictionHowManyPointsToInclude
      IF(stat_is==0)READ(4,*)k        !Initial RNGP, if no statistics
      CLOSE(4)
      PRINT*,"Max number of global runs: ",max_glo_run
! Reading anzac control parameters
      OPEN(4,FILE='anzac_1.in')
      READ(4,*)om_anz_min,om_anz_max
      READ(4,*)z_anz_min,z_anz_max
      CLOSE(4)

! Writing file to transfer the infromation to obrab_10.f
      OPEN(UNIT=4,FILE="trans_obrab.dat")
         WRITE(4,*)kernel_type 
         WRITE(4,*)beta
         WRITE(4,*)refinement
      CLOSE(4)

! setting hvatit as a number which is factor of 10
      hvatit = (hvatit/10) * 10;
! rejecting if it is zero
      IF(hvatit==0) &
      STOP'No possibility: increase local runs for global run number'
! setting how often to determine intermediate quality data and to print
      num_skip=hvatit/5
      PRINT*,"hvatit = ",hvatit,"  num_skip = ",num_skip

! Eliminating consistent-constraints at refinement procedure
      IF(refinement==1)THEN  
         N_Nikolay=0;  start_Nikolay(1)=0.0d0
      ENDIF
      
! checking consistency of precisions
      DO i=1,N_Nikolay-1
         IF(start_Nikolay(i)<start_Nikolay(i+1))THEN
            STOP"precisions must be in the descending order"
         ENDIF
      ENDDO
! Allocating dimesions
      ALLOCATE( om_grid(-num_his-1:num_his+1), &
                      hi_flo(-num_his-1:num_his+1), &
                      hi_flo_kol(-num_his-1:num_his+1), &
                      hi_glob(-num_his-1:num_his+1), &
                      om_grid_big(-num_his_big-1:num_his_big+1), &
                      hi_flo_big(-num_his_big-1:num_his_big+1), &
                      hi_glob_big(-num_his_big-1:num_his_big+1), &
                      om_grid_hei(-num_his_hei-1:num_his_hei+1), &
                      hi_flo_hei(-num_his_hei-1:num_his_hei+1) ) 

! Counts for addressing CCtransform
      zaludil=0.0d0; nastupil(1:N_Nikolay)=0.0d0; KakaShiki=0.0d0

! Data for restriction of heights
      DO i=1,num_his_hei; hi_flo_hei(i)=HUGE(1.0d0); ENDDO;
      IF(refinement==1)THEN; buzi=2.5d0; ELSE; buzi=1.0d0; ENDIF;

! Exclude frequences below zero for T=0 !*CHECK*
      IF(kernel_type==0 .AND. om_min<0.0d0)THEN
        PRINT*,"No negative om_min for T=0 !!!";  STOP
      ENDIF

! Exclude frequences below zero for Bose analysis !*CHECK*
      IF(kernel_type==3 .AND. om_min<0.0d0)THEN
        PRINT*,"No negative om_min for bosons - symmetrized";  STOP
      ENDIF

! Excluding unsymmetric frequency ranges for OC kernel
      IF(kernel_type==1)THEN
          IF(ABS(om_min+om_max)>1.0d-11)THEN
              STOP"Frequency range for OC must be symmetric"
          ENDIF
      ENDIF


! Preparing grid data for histograms
      sh_his = (his_max-his_min)/num_his ! histogram step
      sh_his_big = (his_max_big-his_min_big)/num_his_big ! histogram step big
      sh_his_hei = (om_max-om_min)/num_his_hei ! histogram step hei
      DO i=-1,num_his+1; om_grid(i) = his_min + i*sh_his ; ENDDO !frevalues
      DO i=-1,num_his_big+1;
         om_grid_big(i) = his_min_big + i*sh_his_big ; ENDDO !freq valuesfor big histogramm
      DO i=-1,num_his_hei+1;
         om_grid_hei(i) = om_min + i*sh_his_hei;  ENDDO !freq values forheight restrict
      OPEN(UNIT=4,file='om_grid.dat')
         WRITE(4,*)num_his,om_grid(0:num_his);
      CLOSE(4)
      OPEN(UNIT=4,file='om_grid_big.dat')
         WRITE(4,*)num_his_big,om_grid_big(0:num_his_big);
      CLOSE(4)
      OPEN(UNIT=4,file='om_grid_hei.dat')
         WRITE(4,*)num_his_hei,om_grid_hei(0:num_his_hei);
      CLOSE(4)


      END SUBROUTINE CONTROL_IN
!....................................................................

!--------------------------------------------------------------------
! Set which updates are done or switched of
!--------------------------------------------------------------------
      SUBROUTINE SET_UPDATES
      USE global_control;
      IMPLICIT NONE

      do_shi_full  = .TRUE.
      do_ex_z  = .TRUE.
      do_wid_ch  = .TRUE.
      do_shi_two  = .TRUE.
      do_shi_anz1  = .TRUE.
      do_ex_z_anz1  = .TRUE.
      do_spl_born  = .TRUE.
      do_glue  = .TRUE.

      END SUBROUTINE SET_UPDATES
!....................................................................

!--------------------------------------------------------------------
! Set parameters for direct access files
!--------------------------------------------------------------------
      SUBROUTINE SET_RECORDS
      USE float_configuration; USE ext_control_data;
      USE global_control;
      IMPLICIT NONE
      INTEGER :: maluha, nmnm1
      REAL*8,DIMENSION(8) :: ahh

      CALL ALLO_CONFIGURATION(ienlarge*nf_max,.TRUE.)

! Length for direct access files accumulating configurations of successful attempts
      ref_or_not: IF(refinement==0)THEN

          nf_max_rec = ienlarge * nf_max
          INQUIRE(IOLENGTH=conf_old)nmnm,  &
          om_0(1:nf_max_rec),to_t0(1:nf_max_rec),ro_h0(1:nf_max_rec) !RecordLengthForConfig
          OPEN(4,FILE='conti.dat');WRITE(4,*)conf_old,conf_old;
          CLOSE(4)
          conf_new=conf_old

      ELSE ref_or_not

          super_or_not: IF(superrefinement==0) THEN

              OPEN(UNIT=4,FILE='glo_run.dat')
                  READ(4,*)k,i_glo_performed,i_glo_suc;
              CLOSE(4)
              IF(i_glo_suc<confi_mix)THEN
                  PRINT*,'Too small statistics to start refinement'; STOP;
              ENDIF
              OPEN(UNIT=4,FILE='glo_each.dat'); maluha=0
                 DO i=1,i_glo_suc
                    READ(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i)
                    po_of(i,1:8)=ahh(1:8)
                    IF(nm_of(i)>maluha)maluha=nm_of(i);
                 ENDDO
              CLOSE(4)
              maluha=confi_mix*maluha*2;
              IF(maluha>frec_num)THEN
                  PRINT*,"maluha>frec_num. Cannot transfer to Kolya!"
                  STOP
              ENDIF    
              IF(maluha>nf_max)THEN;
                  nf_max=maluha;
                  CALL ALLO_CONFIGURATION(ienlarge*nf_max,.FALSE.)
                  CALL ALLO_CONFIGURATION(ienlarge*nf_max,.TRUE.)
              ENDIF
              PRINT*,'Max number of frequencies in refinement = ',nf_max
              OPEN(4,FILE='conti.dat');READ(4,*)conf_old,conf_new
              CLOSE(4);
              conf_init=conf_old
              nf_max_rec = ienlarge * nf_max
              INQUIRE(IOLENGTH=conf_new)nmnm, &
                 om_0(1:nf_max_rec),to_t0(1:nf_max_rec),ro_h0(1:nf_max_rec)
!RecordLengthForConfig
               OPEN(4,FILE='conti.dat');WRITE(4,*)conf_old,conf_new;
               CLOSE(4)
               i_glo_suc=0; i_glo_performed=0

          ELSE super_or_not

               !PRINT*,"Do you REALLY want superefinement????"
               !PRINT*,"If YES, press <ENTER>"
               !PAUSE"If not, press <CTRL C>"
               IF(stat_ref/=0)THEN
                   PRINT*,' Continue statistics and make superefinement'
                   PRINT*,' cannot be done simultaneously'; STOP;
               ENDIF
               IF(refinement==0)THEN
                   PRINT*,"No sense to make superefinement if" 
                   PRINT*,"refinement=0"; STOP
               ENDIF    
               OPEN(UNIT=4,FILE='ref_run.dat')
                   READ(4,*)k,i_glo_performed,i_glo_suc;
               CLOSE(4)
               IF(i_glo_suc<confi_mix)THEN
                   PRINT*,'Too small statistics to superrefine'; STOP;
               ENDIF
               OPEN(UNIT=4,FILE='ref_each.dat'); maluha=0
                   DO i=1,i_glo_suc
                     READ(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i)
                     po_of(i,1:8)=ahh(1:8)
                     IF(nm_of(i)>maluha)maluha=nm_of(i);
                   ENDDO
               CLOSE(4)
               maluha=confi_mix*maluha*2;
              IF(maluha>frec_num)THEN
                  PRINT*,"maluha>frec_num. Cannot transfer to Kolya!"
                  STOP
              ENDIF    
               IF(maluha>nf_max)THEN;
                   nf_max=maluha
                   CALL ALLO_CONFIGURATION(ienlarge*nf_max,.FALSE.)
                   CALL ALLO_CONFIGURATION(ienlarge*nf_max,.TRUE.)
               ENDIF
               PRINT*,'Max number of frequencies =',nf_max
               !Rewrite refined to ordinary
               PRINT*,'REWRITING glo_run.dat'
               OPEN(UNIT=4,FILE='glo_run.dat')
                   WRITE(4,*)k,i_glo_performed,i_glo_suc;
               CLOSE(4)
               PRINT*,'REWRITING glo_each.dat'
               OPEN(UNIT=4,FILE='glo_each.dat')
                  DO i=1,i_glo_suc
                    ahh(1:8)=po_of(i,1:8)
                    WRITE(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i)
                  ENDDO
               CLOSE(4)
               OPEN(4,FILE='conti.dat');READ(4,*)conf_old,conf_new
               CLOSE(4)
               conf_init=conf_new; conf_old=conf_new
!RecLenBeforeEnlargement
               nf_max_rec = ienlarge * nf_max 
               INQUIRE(IOLENGTH=conf_new)nmnm, &
                 om_0(1:nf_max_rec),to_t0(1:nf_max_rec),ro_h0(1:nf_max_rec)
!RecordLengthForConfig
               OPEN(UNIT=4,   FILE='ref_conf.dat' ,ACCESS='direct', &
                 RECL=conf_old, FORM='unformatted')
               OPEN(UNIT=3,   FILE='glo_conf.dat' ,ACCESS='direct', &
                 RECL=conf_old, FORM='unformatted')
                 PRINT*,'REWRITING glo_conf.dat'
                 DO i=1,i_glo_suc
                    READ(4,REC=i)nmnm1, &
                   om_3(1:nmnm1),to_t3(1:nmnm1),ro_h3(1:nmnm1)
                    WRITE(3,REC=i)nmnm1, &
                   om_3(1:nmnm1),to_t3(1:nmnm1),ro_h3(1:nmnm1)
                    PRINT*,'i=',i,"  nm_of(i): ",nm_of(i)," nmnm1:",nmnm1
                 ENDDO
               CLOSE(4); CLOSE(3)
               OPEN(4,FILE='conti.dat');WRITE(4,*)conf_old,conf_new;
               CLOSE(4)
               i_glo_suc=0; i_glo_performed=0

          ENDIF super_or_not

      ENDIF ref_or_not

! Length for direct access files accumulating histograms of successful attempts
      INQUIRE(IOLENGTH=rec_len)    om_grid(0:num_his)
                                             !RecordLengthForDirectAccess
      INQUIRE(IOLENGTH=rec_len_big)om_grid_big(0:num_his_big)
                                             !RecordLengthForDirectAccess


      END SUBROUTINE SET_RECORDS
!....................................................................


!--------------------------------------------------------------------
! Allocates dimensions for configuration
!--------------------------------------------------------------------
      SUBROUTINE ALLO_CONFIGURATION(nmf,allo)
      USE useful_parameters; USE float_configuration
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: nmf
      LOGICAL,INTENT(IN) :: allo

      IF(allo)THEN
         ALLOCATE(om_0(nmf),to_t0(nmf),ro_h0(nmf))
         ALLOCATE(om_0_sav(nmf),to_t_sav(nmf),ro_h_sav(nmf))
         ALLOCATE(om_1(nmf),to_t1(nmf),ro_h1(nmf))
         ALLOCATE(om_2(nmf),to_t2(nmf),ro_h2(nmf))
         ALLOCATE(om_3(nmf),to_t3(nmf),ro_h3(nmf))
         ALLOCATE(om_b(nmf),to_tb(nmf),ro_hb(nmf))
         ALLOCATE(om_sh(2*nmf),to_t_sh(2*nmf),ro_h_sh(2*nmf))
         ALLOCATE(om_sh2(2*nmf),to_t_sh2(2*nmf),ro_h_sh2(2*nmf))
         ALLOCATE(om_le(2*nmf),om_ri(2*nmf))
      ELSE
         DEALLOCATE(om_0,to_t0,ro_h0)
         DEALLOCATE(om_0_sav,to_t_sav,ro_h_sav)
         DEALLOCATE(om_1,to_t1,ro_h1)
         DEALLOCATE(om_2,to_t2,ro_h2)
         DEALLOCATE(om_3,to_t3,ro_h3)
         DEALLOCATE(om_b,to_tb,ro_hb)
         DEALLOCATE(om_sh,to_t_sh,ro_h_sh)
         DEALLOCATE(om_sh2,to_t_sh2,ro_h_sh2)
         DEALLOCATE(om_le,om_ri)
      ENDIF

      END SUBROUTINE ALLO_CONFIGURATION
!....................................................................


!--------------------------------------------------------------------
! Reading the green function or correlator in imaginary time
! or Matsubara representatrion
!--------------------------------------------------------------------
      SUBROUTINE RED_CORREL
      USE ext_control_data; USE time_data; USE global_control
      USE time_data
      IMPLICIT NONE

! KERNEL_GDE
      SELECT CASE(kernel_type)

         CASE(0,1,3)

         OPEN(4,FILE='infloa.in')
            READ(4,*)nt ;
            READ(4,*)(ta(i),gr(i),sigma(i),i=1,nt) ! GF, time, err_bar-relativ
         CLOSE(4)
         PRINT*,"Input imag time correlator contains ", nt , "points"
         ALLOCATE(gc(nt),gc_global(nt),gc_at(-1:3,nt))
         ALLOCATE(deviation(nt),deviation_glob(nt))

         CASE(2)
             
         OPEN(4,FILE='infloa.in')
            READ(4,*)n_all, n_beg, n_end;
            READ(4,*)(ta_uk(i),gr_uk(i),sigma_uk(i),i=1,n_all) ! GF, time, err_bar-relativ
         CLOSE(4)
         !Setting selected tau-points
         DO i = 1, n_beg;
             ta(i)=ta_uk(i); gr(i)=gr_uk(i); sigma(i)=sigma_uk(i)
         ENDDO    
         DO j = 1, n_end; i = n_all - n_end + j; l=n_beg+j
            ta(l)=ta_uk(i); gr(l)=gr_uk(i); sigma(l)=sigma_uk(i) 
         ENDDO    
         nt=n_beg+n_end
         IF(nt>n_all)STOP"nt>n_all"
         OPEN(UNIT=4,FILE="divide.dat")
         DO i=1,nt
             WRITE(4,*)ta(i),gr(i) ,sigma(i)
         ENDDO    
         CLOSE(4)
         PRINT*,"Input imag time correlator contains ", nt , "points"
         ALLOCATE(gc(nt),gc_global(nt),gc_at(-1:3,nt))
         ALLOCATE(deviation(nt),deviation_glob(nt))
         
         CASE(4,5)

         OPEN(4,FILE='matsubara.in')
            READ(4,*)nt ;
            DO i=1,nt
                READ(4,*)Om_inp_re(i),G_inp_re(i),G_inp_im(i),sigma(i)
!MatFr,ReGF,ImGF,ere_bar-relativ
                IF(kernel_type==4)THEN
                   Om_inp_re(i) = ( pi/beta ) * ( 2*(i-1) + 1 )
                ELSE IF(kernel_type==5)THEN 
                   Om_inp_re(i) = ( pi/beta ) * ( 2*(i-1) )
                ENDIF   
                Om_input(i) = DCMPLX(0.0d0,Om_inp_re(i))
                G_input(i) = DCMPLX(G_inp_re(i),G_inp_im(i))
            ENDDO
         CLOSE(4)
         PRINT*,"Input Matsubara correlator has ", nt , "frequencies"
         ALLOCATE(gc_MA(nt),gc_global_MA(nt),gc_at_MA(-1:3,nt))
         ALLOCATE(deviation(nt),deviation_im(nt),deviation_glob(2*nt))
         
         CASE(6)
             
         OPEN(4,FILE="angle_tau.in")    
            READ(4,*)nt
            IF(MOD(nt,2)==1)STOP"nt mus be even if kernel=6"
            nt_d2=nt/2
            READ(4,*)(ta(i),gr(i),sigma(i),i=1,nt) ! GF, time, err_bar-absolute
         CLOSE(4)
         ALLOCATE(gc(nt),gc_global(nt),gc_at(-1:3,nt))
         ALLOCATE(deviation(nt_d2),deviation_im(nt_d2),deviation_glob(nt))
         
         CASE(7)
             
         OPEN(4,FILE="imag_angle_tau.in")    
            READ(4,*)nt_compl
            IF(MOD(nt_compl,2)==1)STOP"nt mus be even if kernel=7"
            nt_d2=nt_compl/2
            IF(nt_compl>0)THEN
               READ(4,*)(ta(i),gr(i),sigma(i),i=1,nt_compl) ! GF, complex time, err_bar-absolute
            ENDIF
            READ(4,*)nt_imag
            IF(nt_imag>0)THEN
               READ(4,*)(ta(i),gr(i),sigma(i),i=nt_compl+1,nt_compl+nt_imag) ! GF, imag ti, err_bar-abs
            ENDIF
         CLOSE(4)
         PRINT*,"nt_compl = ",nt_compl
         PRINT*,"nt_imag =",nt_imag
         !PAUSE"CHECK numbers"
        ! Excluding points untill selected "complex_include", "imaginary_include"
         IF(complex_include>nt_d2)STOP"Can not complex_include>nt_d2"
         IF(imaginary_include>nt_imag)THEN
             PRINT*,"imaginary_include:",imaginary_include
             PRINT*,"nt_imag:",nt_imag
             STOP"Can not imaginary_include>nt_imag"
         ENDIF    
        !
         gr( 1 : complex_include ) = gr( 1 : complex_include )
         ta( 1 : complex_include ) = ta( 1 : complex_include )
         sigma( 1 : complex_include ) = sigma( 1 : complex_include )
        !
         gr( complex_include+1 : 2*complex_include ) =  &
         gr( nt_d2+1 : nt_d2+complex_include )
         ta( complex_include+1 : 2*complex_include ) =  &
         ta( nt_d2+1: nt_d2+complex_include )
         sigma( complex_include+1 : 2*complex_include ) =  &
         sigma( nt_d2+1 : nt_d2+complex_include )
        !
          gr( (2*complex_include)+1 : (2*complex_include)+imaginary_include ) = &
          gr( nt_compl+1 : nt_compl+imaginary_include )
          ta( (2*complex_include)+1 : (2*complex_include)+imaginary_include ) = &
          ta( nt_compl+1 : nt_compl+imaginary_include )
          sigma( (2*complex_include)+1 : (2*complex_include)+imaginary_include ) = &
          sigma( nt_compl+1 : nt_compl+imaginary_include )
         !
          nt_compl=2*complex_include
          nt_d2=complex_include
          nt_imag=imaginary_include
          nt = nt_compl+nt_imag
          ALLOCATE(gc(nt),gc_global(nt),gc_at(-1:3,nt))
          ALLOCATE(deviation(nt_d2+1),deviation_im(nt_d2+1),deviation_imatau(nt_imag))
          ALLOCATE(deviation_glob(nt))
         ! writing check file
          OPEN(4,FILE="chec.dat")
             WRITE(4,*)nt_compl
             WRITE(4,*)(ta(i),gr(i),sigma(i),i=1,nt_compl) ! GF, complex time, err_bar-absolute
             WRITE(4,*)nt_imag
             WRITE(4,*)(ta(i),gr(i),sigma(i),i=nt_compl+1,nt_compl+nt_imag) ! GF, imag time, err_bar-abs
          CLOSE(4)
          !PAUSE"Cheking truncated file"
          OPEN(4,FILE="alldata.dat")
             WRITE(4,*)(ta(i),gr(i),sigma(i),i=1,nt) ! GF, complex time, err_bar-absolute
          CLOSE(4)
          !PAUSE"Cheking truncated file"
          END SELECT

      END SUBROUTINE RED_CORREL
!....................................................................

!--------------------------------------------------------------------
! Set updates management parameters for whole code
!--------------------------------------------------------------------
      SUBROUTINE SET_PROC_PAR
      USE ext_control_data; USE proc_par; USE global_control
      IMPLICIT NONE

! Minimal norma which is not in anzac
      norm_fr_che = ABS(norm_min-z_anz_max)
! Absolute minimum of frequency weight
      ato_abs = ato * norm_fr_che
! Minimal height
      min_height=ato_abs/(om_max-om_min)
! Adjusting limits for configuration mixing in refinement procedure
      IF(refinement/=0) THEN
         ato_abs = ato_abs/confi_mix; min_height=min_height/confi_mix
      ENDIF
! Check compatibility of data
      IF(max_in_fr>nf_max)STOP'max_in_fr > nf_max'

      END SUBROUTINE SET_PROC_PAR
!....................................................................

!--------------------------------------------------------------------
! Tabulating the "optical kernel" function for finite temperatures
! kernel type convention:
! Kernel_type =
!     0  -  exp(-\omega \tau)
!     1  -  optical conductivity finite T
!     2  -  Fermi finite T imaginary time
!     3  -  Bose  finite T imaginary time symmetrized
!     4  -  Fermi finite T Matsubara
!     5  -  Bose  finite T Matsubara
!     6  -  exp(-\omega \tau exp(i\phi)) -slanted \tau --> \tau exp(i\phi)     
!     7  -  exp(-\omega \tau exp(i\phi)) -slanted \tau and  exp(-\omega \tau) inag tau   
!--------------------------------------------------------------------
      SUBROUTINE TABU_KERNEL
      USE time_data; USE ext_control_data; USE tabul_dat
      IMPLICIT NONE
      REAL*8,EXTERNAL :: EX,AVVA
      REAL*8 :: fufu, ola, curr, burr, eb1, eb2, eb3, eb4, cuti
      REAL*8,ALLOCATABLE,DIMENSION(:) :: fla
      REAL*8,ALLOCATABLE,DIMENSION(:,:) :: cfr0
      INTEGER :: i_gliu, desu

100   FORMAT(1x,1000(ES20.10))

! For kernel_type = 0, 4, 5 there is no need to tabulate
      IF(kernel_type==0 .OR. kernel_type==4 .OR. kernel_type==5)THEN
          PRINT*,"No tabulation of kernel since analytics is intended"
          RETURN
      ENDIF

! BELOW: kernel_type /= (0, 4, 5), there is need to tabulate

! Covering by tabulation a range  [om_min_tab, om_max_tab]
! which is broader than [om_min,om_max]
      IF(om_max>0.0d0)THEN; om_max_tab=om_max*1.01;
      ELSE;                             om_max_tab=om_max*0.99;
      ENDIF
      IF(om_min>0.0d0)THEN; om_min_tab=om_min*0.99;
      ELSE;                             om_min_tab=om_min*1.01;
      ENDIF
! Settting steps for tabulation and integration
      sha_tab=(om_max_tab-om_min_tab) / (2*n_tabu);
      sha_int=sha_tab/su_gri

! Checking various data consistencies
      imag_time: IF(kernel_type>=1 .AND. kernel_type<=3)THEN;

          max_tau: IF(ta(nt)>beta)THEN
              PRINT*,'Tau=',ta(nt),'  is larger than beta',beta; STOP;
          ENDIF max_tau

          max_beta: IF( &
             MAX(ABS(om_max_tab),ABS(om_min_tab)) *0.5d0*beta > &
             ex_ma )THEN;
                 PRINT*,"Out of tabulating range!"
                 PRINT*,"om_max_tab = ",om_max_tab
                 PRINT*,"om_min_tab = ",om_min_tab
                 PRINT*,"beta = ",beta
          ENDIF max_beta

      ENDIF imag_time

! Allocating arrays
      ALLOCATE(tab(nt,0:2*n_tabu+1),om_tab(0:2*n_tabu+1))
      ALLOCATE(fla(0:su_gri))
      ALLOCATE(cfr0(nt,0:2*n_tabu+1))

! Tabulating over imaginary time points
      tabu_tau_Matsu: DO i=1,nt !big loop
         PRINT*,'TABULATING: nt =',nt,'   i =',i; !Loop over tau or Matsubara
         fufu=0.0d0; tab(i,0)=0.0d0; om_tab(0)=om_min_tab
         tabu_ome: DO j=1,2*n_tabu+1; !Loop over tabulated frequencies
             om_tab(j)=om_min_tab+sha_tab*j

!KERNEL_GDE
             tabu_for_integ: DO l=0,su_gri; ola=om_tab(j-1)+sha_int*l;
                curr=ola*(0.5d0*beta-ta(i)); burr=ola*0.5d0*beta;
                eb1=EX(curr); eb2=EX(burr);
                SELECT CASE(kernel_type)
                CASE(1) ! optical conductivity
                        IF(ABS(burr)<1.0d-12)THEN;
                          fla(l) = 1.0d0/(pi*beta)
                    ELSE
                         eb4=1.0d0/eb2;
                         fla(l) = (ola/pi) * (eb1/(eb2-eb4))
                    ENDIF
                CASE(2) ! Femions imag time
                         eb4=1.0d0/eb2;
                         fla(l) = eb1/(eb2+eb4)
                CASE(3) ! Bosons imag time symmetrized
                         eb3=1.0d0/eb1; eb4=1.0d0/eb2
                         fla(l) = (eb1+eb3)/(eb2+eb4)
                CASE(6)
                         cuti = ola*ta(i)
                         IF(i<=nt_d2)THEN
                             fla(l) =  EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                         ELSE
                             fla(l) = -EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                         ENDIF    
                CASE(7)
                         cuti = ola*ta(i)
                         IF(nt_d2>0)THEN
                            IF(i<=nt_d2)THEN
                                fla(l) =  EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                            ELSE IF(i>nt_d2 .AND. i<=nt_compl)THEN
                                fla(l) = -EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                            ELSE IF(i>nt_compl .AND. i<=nt)THEN
                                fla(l) = EX(-cuti)
                            ELSE
                                STOP"What else can be"
                            ENDIF    
                         ELSE
                                fla(l) = EX(-cuti)
                         ENDIF    
                CASE DEFAULT
                   STOP'No case in tabulation'
                END SELECT

             ENDDO tabu_for_integ

             ! Integarting between tabu steps
             integ: DO l=1,su_gri;
             fufu = fufu + sha_int*(fla(l-1)+fla(l))*0.5d0
             ENDDO integ
             ! Storing the result of integartion
             tab(i,j)=fufu

         ENDDO tabu_ome !Loop over tabulated frequencies end
      ENDDO tabu_tau_Matsu !big loop end
! End tabulating over imaginary time points or Matsubara frequencies

! Writing tabulated file for visual control
! a) omega-dependence for diffrerent times
!       i_gliu=0
!       DO i=1,nt,nt/4-1; !PRINT*,'Control done for:',i,ta(i)
!        i_gliu=i_gliu+1
!        DO j=0,2*n_tabu; cfr0(i_gliu,j)=tab(i,j); ENDDO
!       ENDDO
!       OPEN(UNIT=4,FILE='ta.dat')
!       DO j=0,2*n_tabu;
!        WRITE(4,100)om_tab(j),(cfr0(i,j),i=1,i_gliu)
!       ENDDO
!       CLOSE(4)
! b) time-dependence for different omega
       OPEN(UNIT=4,FILE='tata.dat')
       DO i=1,nt;
       WRITE(4,100)ta(i), tab(i,5), tab(i,n_tabu/2), tab(i,n_tabu), &
       tab(i,3*n_tabu/2), tab(i,2*n_tabu)
       ENDDO
       CLOSE(4)
       PRINT*,"Time dependence check is completed"
! c) check of the interpolation function
       i=5; desu=4
       OPEN(UNIT=4,FILE='inte1.dat')
       DO j=1,2*n_tabu;
        WRITE(4,100)om_tab(j),tab(i,j)
       ENDDO
       CLOSE(4)
       PRINT*,"Inte1"
       OPEN(UNIT=4,FILE='inte2.dat')
       DO j=1,2*n_tabu*desu; ola=om_min_tab+(sha_tab/desu)*j
        WRITE(4,100)ola,avva(i,ola)
       ENDDO
       CLOSE(4)
       PRINT*,"Check of interpolation is completed"

       DEALLOCATE(cfr0)

      END SUBROUTINE TABU_KERNEL
!....................................................................

!--------------------------------------------------------------------
! Reading the green function or correlator in imaginary time
!--------------------------------------------------------------------
      SUBROUTINE STA_READ
      USE ext_control_data; USE global_control
      IMPLICIT NONE
      INTEGER :: ij
      REAL*8,DIMENSION(8) :: ahh

      starting_procedure = .FALSE.

! Setting scaler for manual tuning of precision
      OPEN(UNIT=4,FILE='manupre.in')
          READ(UNIT=4,FMT=*,ERR=2,END=2)scaler;
          PRINT*,'Manual tuning of precision, SCALER = ',scaler
      CLOSE(4)
      GOTO 1
2     CONTINUE;
      scaler=1.0d0;
      PRINT*,'No manual tuning is attempted, SCALER = ',scaler
1     CONTINUE

! Reading statistics if any
      ref_or_not: IF(refinement==0) THEN; !No refinement below

         stat_or_not: IF(stat_is/=0) THEN

            OPEN(UNIT=4,FILE='glo_run.dat')
               READ(4,*)k,i_glo_performed,i_glo_suc;
            CLOSE(4)
            OPEN(UNIT=4,FILE='glo_each.dat');
               DO i=1,i_glo_suc
                  READ(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i);
                  po_of(i,1:8)=ahh(1:8)
               ENDDO
            CLOSE(4)
            OPEN(UNIT=4,FILE='found_pr.dat')
               READ(4,*)char; READ(4,*)char; READ(4,*)char
               DO ij=1,attempts;
                   READ(4,*)prec(ij) ;
               ENDDO;
            CLOSE(4)
            CALL ORDERD(attempts,prec,pre1)
            best_dev=pre1(attempts/prec_frac)*scaler
            stat_dev=best_dev*0.95d0
            PRINT*,"Data loaded. Desirable precision is set to : " &
                  ,1.0d0/best_dev

         ELSE stat_or_not;

             starting_procedure=.TRUE.;

         ENDIF stat_or_not

      ELSE ref_or_not; !Refinement below

         CALL HEIGHT_LIMIT

         stat_or_not2: IF(stat_ref/=0) THEN

            OPEN(UNIT=4,FILE='ref_run.dat')
               READ(4,*)k,i_glo_performed,i_glo_suc;
            CLOSE(4)
            OPEN(UNIT=4,FILE='ref_each.dat');
               DO i=1,i_glo_suc
                  READ(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i);
                  po_of(i,1:8)=ahh(1:8)
               ENDDO
            CLOSE(4)
            OPEN(UNIT=4,FILE='found_pr.dat')
               READ(4,*)char; READ(4,*)char; READ(4,*)char
               DO ij=1,attempts;
                  READ(4,*)prec(ij) ;
               ENDDO;
            CLOSE(4)
            CALL ORDERD(attempts,prec,pre1)
            best_dev=pre1(attempts/prec_frac)*scaler
            stat_dev=best_dev*0.95d0
            PRINT*,"Data loaded. Desirable precision is set to : " &
                       ,1.0d0/best_dev


         ELSE stat_or_not2;

            starting_procedure=.TRUE.;

         ENDIF stat_or_not2

      ENDIF ref_or_not

      END SUBROUTINE STA_READ
!....................................................................

!--------------------------------------------------------------------
! One attempt to fit spectrum starting from rendomly generated configuration
!--------------------------------------------------------------------
      SUBROUTINE ADJUST_PRECISION
      USE global_control;
      USE ext_control_data; USE float_configuration
      IMPLICIT NONE
      LOGICAL :: succes_code,Udachi
      INTEGER :: i_att, i_a, ij
      REAL*8,DIMENSION(8) :: ahh

! ======= LOOP over attempts to find PRECISION ==============
      precision_runs: DO i_att=1,attempts;  i_glo_run=i_att-attempts

          CALL ONE_ATTEMPT(.FALSE.,succes_code)

          !Storing precision and configuration reached after one attempt
          prec(i_att)=z_best
          OPEN(UNIT=8, FILE='adjust_c.dat' ,ACCESS='direct', &
                               RECL=conf_new, FORM='unformatted')
             WRITE(8,REC=i_att)nmnmb, &
            om_b(1:nmnmb),to_tb(1:nmnmb),ro_hb(1:nmnmb);
          CLOSE(8)

! Creating and writing current histogram
          CALL HISTO_FORM(.TRUE.)
          OPEN(UNIT=8, FILE='adjust_h.dat' ,ACCESS='direct', &
                               RECL=rec_len, FORM='unformatted')
                WRITE(8,REC=i_att)hi_flo(0:num_his);
          CLOSE(8)
          OPEN(UNIT=8, FILE='adjust_h_big.dat' ,ACCESS='direct', &
                               RECL=rec_len_big, FORM='unformatted')
                WRITE(8,REC=i_att)hi_flo_big(0:num_his_big);
          CLOSE(8)

! Storing parameters
          co_of(i_att,1)=z_best;
          co_of(i_att,2)=max_deviation
          co_of(i_att,3)=ave_deviation;
          co_of(i_att,4)=om_anz_b
          co_of(i_att,5)=z_anz_b
          co_of(i_att,6)=kurik
          co_of(i_att,7)=initial_k
          co_of(i_att,8)=kappa
          ng_of(i_att)=nmnmb

! Making flo_kol diagram
          nmnm = nmnmb ;               om_0(1:nmnm)=om_b(1:nmnm)
          to_t0(1:nmnm)=to_tb(1:nmnm); ro_h0(1:nmnm)=ro_hb(1:nmnm)
          om_anz_0 = om_anz_b ; z_anz_0 = z_anz_b               !anzac_1 float
          CALL vert_slice(Udachi)
          slicing_success: IF(Udachi)THEN;
             kernel: IF(kernel_type<8)THEN; !Only 0,1,2,3,4,5,6,7 kernels
                 IF(refinement/=1)THEN
                    !CALL Data_to_Kol
                 ENDIF   
             ELSE kernel
                     PAUSE"Only kernel_type<8 Consistent costraints";
             ENDIF kernel
          ELSE slicing_success
                ! PRINT*,"*************** UDACHI NET NET NET **********"
          ENDIF slicing_success
          CALL HISTO_FORM(.FALSE.)
          hi_flo_kol(0:num_his)=hi_flo(0:num_his)
          OPEN(UNIT=8, FILE='adjust_h_kol.dat' ,ACCESS='direct', &
                               RECL=rec_len, FORM='unformatted')
             WRITE(8,REC=i_att)hi_flo_kol(0:num_his);
          CLOSE(8)
! End Making flo_kol diagram

      ENDDO precision_runs
! ======= LOOP over attempts to find PRECISION =END==========

!      DO i=1,attempts
!         PRINT*,co_of(i,1:8)
!      ENDDO
!      PAUSE'Nu i kak?'

! Orgering and determine best reciprocal deviation
      CALL ORDERD(attempts,prec,pre1)
      best_dev=pre1(attempts/prec_frac);
      stat_dev=best_dev*0.95d0

! Writing report about found precision
      OPEN(UNIT=4,FILE='found_pr.dat')
      WRITE(4,*)' ATTEMPTS=',attempts
      WRITE(4,*)' BEST DEVIATION=',best_dev
      WRITE(4,*)' STAT DEVIATION=',stat_dev
      DO ij=1,attempts;
          WRITE(4,*)prec(ij) ;
      ENDDO;
      CLOSE(4)

! Histogram which were found in precision attempta
      OPEN(UNIT=8,       FILE='adjust_h.dat' ,ACCESS='direct', &
                RECL=rec_len, FORM='unformatted')
          OPEN(UNIT=9, FILE='adjust_h_big.dat' ,ACCESS='direct', &
                               RECL=rec_len_big, FORM='unformatted')
          OPEN(UNIT=12, FILE='adjust_h_kol.dat' ,ACCESS='direct',  &
                               RECL=rec_len, FORM='unformatted')
! Histograms to be kept on further runs
      IF(refinement==0) THEN
          OPEN(UNIT=4,       FILE='glo_spec.dat' ,ACCESS='direct', &
                  RECL=rec_len, FORM='unformatted')
      ELSE
          OPEN(UNIT=4,       FILE='ref_spec.dat' ,ACCESS='direct', &
                 RECL=rec_len, FORM='unformatted')
      ENDIF
      IF(refinement==0) THEN
          OPEN(UNIT=7,       FILE='glo_spec_big.dat' ,ACCESS='direct', &
                  RECL=rec_len_big, FORM='unformatted')
      ELSE
          OPEN(UNIT=7,       FILE='ref_spec_big.dat' ,ACCESS='direct', &
                 RECL=rec_len_big, FORM='unformatted')
      ENDIF
      IF(refinement==0) THEN
          OPEN(UNIT=11,       FILE='glo_spec_kol.dat' ,ACCESS='direct', &
                  RECL=rec_len, FORM='unformatted')
      ELSE
          OPEN(UNIT=11,       FILE='ref_spec_kol.dat' ,ACCESS='direct', &
                 RECL=rec_len, FORM='unformatted')
      ENDIF

! Configurations whihc were found in precision attempts
      OPEN(UNIT=10,       FILE='adjust_c.dat' ,ACCESS='direct', &
              RECL=conf_new, FORM='unformatted')
! Configurations to be kept on further runs
      IF(refinement==0) THEN
          OPEN(UNIT=3,       FILE='glo_conf.dat' ,ACCESS='direct', &
                  RECL=conf_new, FORM='unformatted')
      ELSE
          OPEN(UNIT=3,       FILE='ref_conf.dat' ,ACCESS='direct', &
                  RECL=conf_new, FORM='unformatted')
      ENDIF


      DO i_a=1,attempts
          PRINT*,i_a
          IF(prec(i_a)>=best_dev)THEN;
            i_glo_suc=i_glo_suc+1
            ! Collecting histograms for successfull spectra
            READ(8,REC=i_a)hi_flo(0:num_his);
            WRITE(4,REC=i_glo_suc)hi_flo(0:num_his)
            ! Collecting kol gistograms for successfull spectra
            READ(12,REC=i_a)hi_flo_kol(0:num_his)
            WRITE(11,REC=i_glo_suc)hi_flo_kol(0:num_his)
            ! Collecting big gistograms for successfull spectra
            READ(9,REC=i_a)hi_flo_big(0:num_his_big)
            WRITE(7,REC=i_glo_suc)hi_flo_big(0:num_his_big)
            ! Collecting configurations for successfull spectra
            READ(10,REC=i_a)nmnmb, &
              om_b(1:nmnmb),to_tb(1:nmnmb),ro_hb(1:nmnmb);
            WRITE(3,REC=i_glo_suc)nmnmb, &
            om_b(1:nmnmb),to_tb(1:nmnmb),ro_hb(1:nmnmb)
            ! Setting parameters data for successfull runs
            po_of(i_glo_suc,1:8)=co_of(i_a,1:8)
            nm_of(i_glo_suc)=ng_of(i_a)
          ENDIF
      ENDDO;

      CLOSE(3); CLOSE(4); CLOSE(7); CLOSE(8); CLOSE(9); CLOSE(10);
      CLOSE(8); CLOSE(11); CLOSE(12)

      IF(refinement==0)THEN;
          OPEN(UNIT=4,FILE='glo_run.dat')
      ELSE;
          OPEN(UNIT=4,FILE='ref_run.dat')
      ENDIF;
      WRITE(4,*)k,i_glo_run,i_glo_suc;
      CLOSE(4)

      IF(refinement==0)THEN; OPEN(UNIT=4,FILE='glo_each.dat')
      ELSE;                             OPEN(UNIT=4,FILE='ref_each.dat')
      ENDIF
      DO i=1,i_glo_suc
          ahh(1:8)=po_of(i,1:8)
          WRITE(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i);
      ENDDO
      CLOSE(4)


      END SUBROUTINE ADJUST_PRECISION
!...........................................................................

!--------------------------------------------------------------------
! GLOBAL RUNs for free initial frequency generation
!--------------------------------------------------------------------
      SUBROUTINE GLOBAL_FREE
      USE ext_control_data ; USE global_control ;
      IMPLICIT NONE
      LOGICAL :: succes_code

      DO i_glo_run=i_glo_performed+1,many_times
          IF(i_glo_run==max_glo_run) EXIT
          CALL ONE_ATTEMPT(.TRUE.,succes_code)
          CALL ATTEMPT_WRITE(succes_code)
      ENDDO

      END SUBROUTINE global_free
!....................................................................

!--------------------------------------------------------------------
! One attempt to fit spectrum starting from rendomly generated configuration
!--------------------------------------------------------------------
      SUBROUTINE ONE_ATTEMPT(global,succes_code)
      USE global_control ; USE proc_par; USE float_configuration
      USE ext_control_data;
      IMPLICIT NONE
      LOGICAL,INTENT(IN) :: global !In .FALSE. - means adjust pecision
      LOGICAL,INTENT(INOUT) :: succes_code
      REAL*8,EXTERNAL :: ANN
      REAL*8,ALLOCATABLE,DIMENSION(:) :: odl,odr
      LOGICAL :: gotovo, pravilno, pra_norm, pra_rang, pra_chuk
      LOGICAL :: pra_num_fre
      LOGICAL :: kolya_was_now, Udachi
      REAL*8 :: buli_now, over_buli, curr_norm, hei, omp, halfwid
      INTEGER :: ij, iku, i_Nikolay

      ALLOCATE(odl(ienlarge*nf_max),odr(ienlarge*nf_max))

! Initilizing configuration
      IF(refinement==0)THEN
            CALL INIT_FREC
            CALL CHECK(0,todo)
      ELSE
            CALL INIT_REFINED_FREC
            CALL CHECK(-1,todo)
      ENDIF
! For DEBUG
!     CALL HISTO_FORM; CALL LOOP_WRITE; PAUSE;
! For DEBUG END
! Creating parameters for one attempt
      CALL LOCAL_RUN_PAR     !Creating parameters for one attempt
! Initilizing parameters
      succes_code=.false.;
      i_Nikolay=1
      zaludil=zaludil+1.0d0

!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      attempt_cycle: DO i_loc_run=1,hvatit    ! One attempt untill hvatit



         IF(i_Nikolay<=N_Nikolay)THEN
            skip_further=.FALSE.
         ELSE
            skip_further=.TRUE.
         ENDIF
         kolya_was_now=.FALSE.

         CALL ONE_LOOP_PAR      !Creating parameters for one LOOP

         kolya_was_now=.FALSE.

! Call consistent constraints one time
         skip_fur: IF(.NOT. skip_further &
                         .AND. i_loc_run<(8*hvatit)/10 )THEN
            buli_now = &
           ANN(om_anz_0,z_anz_0,om_0,ro_h0,to_t0, &
                  anorma_0,nmnm,.true.,-1)
            over_buli=1.0d0/buli_now;
            probuem: IF(over_buli<start_Nikolay(i_Nikolay) .AND. &
                              nmnm>ista_Nikolay)THEN
               CALL vert_slice(Udachi)
               slicing_success: IF(Udachi)THEN;
                  IF(print_additional)THEN
                     PRINT*,"OVER_BULI : ",over_buli,nmnm;
                  ENDIF
                  kernel: IF(kernel_type<8)THEN; !Only 0-7 kernels CC introduced
                     CALL Data_to_Kol 
                  ELSE kernel
                     PAUSE"CC only for kernel_type<8 exist";
                  ENDIF kernel
                  kolya_was_now=.TRUE. !Says that just now Kolyas subroutines worked
                  nastupil(i_Nikolay)=nastupil(i_Nikolay)+1.0d0
                  i_Nikolay=i_Nikolay+1
               ELSE slicing_success
                ! PRINT*,"*************** UDACHI NET NET NET **********"
               ENDIF slicing_success
            ELSE probuem
               CONTINUE
            ENDIF probuem
         ENDIF skip_fur

! Making one global update
        buli_inrun=buli
        global_update_cycle: DO ij=1,n_cikl         !start LOOP
          CALL STEP_SCRATCH(ij)  !forming sratch data for one STEP
          CALL ONE_UPDATE          !one step for update attempt
        ENDDO global_update_cycle                 !end LOOP
! End Making one global update

        chuki_po = &
       ANN(om_anz_b,z_anz_b,om_b,ro_hb,to_tb,anorma_b,nmnmb,.true.,-1)

        duha_all = duha_all + 1.0d0
! Assunming that all is OK with configuration
        pravilno = .TRUE. !Assuming correct all
        pra_norm = .TRUE. !Assuming correct norm
        pra_rang = .TRUE. !Assuming correct range
        pra_chuk = .TRUE. !Assuming that the deviation is improved
        pra_num_fre = .TRUE. !Assuming that not more frequencies than record length

! Checking improvement of deviation if not after kolya worked
! and accept any correct configuration if kolya worked provided
! sum rules were satisfied
        IF(.NOT. kolya_was_now)THEN
           IF(chuki_po<chuki_do)THEN
              !PRINT*,"No improvement: ",chuki_po/chuki_do,"  < 1"
              pravilno = .FALSE.; pra_chuk = .FALSE.
           ENDIF
        ENDIF
! Checking norma
        curr_norm = SUM(to_tb(1:nmnmb))+z_anz_b
        IF(curr_norm < norm_min)THEN;
            PRINT*,"Current norm < norm_min, current = ",curr_norm;
            pravilno = .FALSE.; pra_norm = .FALSE.
        ENDIF
        IF(curr_norm > norm_max)THEN;
            PRINT*,"Current norm > norm_max, current = ",curr_norm;
            pravilno = .FALSE.; pra_norm = .FALSE.
        ENDIF
! Checking positiveness and ranges
        DO iku = 1 , nmnmb
          hei=ro_hb(iku);  omp=om_b(iku); halfwid=(to_tb(iku)/hei)/un2
          odl(iku) = omp - halfwid  ;  odr(iku) = omp + halfwid
          IF(odl(iku)<om_min)THEN;
              PRINT*,"Frequency below min, left = ",odl(iku)
              pravilno = .FALSE.; pra_rang = .FALSE.
          ENDIF
          IF(odr(iku)>om_max)THEN;
              PRINT*,"Frequency above max, righ = ",odr(iku)
              pravilno = .FALSE.; pra_rang = .FALSE.
          ENDIF
        ENDDO
! Checking not overrun of maximal number of frequencies
        IF(nmnmb >= nf_max_rec)THEN
            pravilno = .FALSE.; pra_num_fre = .FALSE.
        ENDIF
        
! Counting bad and good cases
        IF(.NOT. pravilno)duha_bad = duha_bad +1.0d0
        IF(.NOT. pra_chuk)duha_chu = duha_chu +1.0d0
        IF(.NOT. pra_norm)duha_nor = duha_nor +1.0d0
        IF(.NOT. pra_rang)duha_ran = duha_ran +1.0d0
        IF(.NOT. pra_num_fre)duha_num=duha_num+1.0d0

! Reverting old values if global run is not satisfactory
        IF( .NOT. pravilno )THEN
         !PRINT*,'===================================================='
         !PRINT*,'CHUKI_do: ',chuki_do
         !PRINT*,'CHUKI_po: ',chuki_po,'   Z_best: ',z_best
         nmnmb=nmnm_sav ;               om_b(1:nmnmb)=om_0_sav(1:nmnmb)
         to_tb(1:nmnmb)=to_t_sav(1:nmnmb);
         ro_hb(1:nmnmb)=ro_h_sav(1:nmnmb)
         om_anz_b = om_anz_sav ; z_anz_b = z_anz_sav
         anorma_b  = anorma_sav
        ENDIF

        CALL ONE_LOOP_PRINT(global) !add statistic for one local run if "stat_dev"

        IF(global)THEN
             CALL STAT_ADD(gotovo)  !Forming the final data for one attempt
                                                   !and set gotovo=.true. if "best_dev" is reached
             IF(gotovo)THEN; succes_code=.true.; ENDIF
        ENDIF


      ENDDO attempt_cycle                 !END of one attempt untill 'hvatit'
!>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

      DEALLOCATE(odl,odr)

      END SUBROUTINE ONE_ATTEMPT
!....................................................................

!--------------------------------------------------------------------
! Checking the validity of configuration
!--------------------------------------------------------------------
      SUBROUTINE CHECK(location,do_check)
      USE useful_parameters; USE float_configuration;
      USE ext_control_data
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: location
      LOGICAL,INTENT(IN) :: do_check

      REAL*8,ALLOCATABLE,DIMENSION(:) :: odl, odr
      REAL*8 :: halfwid, hei, omp, anoi
      INTEGER :: n

      IF(.NOT. do_check)RETURN

      ALLOCATE(odl(5*nf_max),odr(5*nf_max))

      anoi=SUM(to_t0(1:nmnm))+z_anz_0
      IF(anoi<norm_min-dopusk .OR. anoi>norm_max+dopusk)THEN
        !PRINT*,"location = ",location;
        !PRINT*,"NORMA = ",anoi; !STOP
      ENDIF
 
      DO n = 1 , nmnm
         hei=ro_h0(n);  omp=om_0(n); halfwid=(to_t0(n)/hei)/un2
         odl(n) = omp - halfwid  ;  odr(n) = omp + halfwid
         IF(odl(n)<om_min-dopusk .OR. odr(n)<om_min-dopusk)THEN
             PRINT*,"Spectrum below om_min: ", odl(n), odr(n)
             PRINT*,"location = ",location; !STOP
         ENDIF
         IF(odl(n)>om_max+dopusk .OR. odr(n)>om_max+dopusk)THEN
             PRINT*,"Spectrum above om_max: ", odl(n), odr(n)
             PRINT*,"location = ",location; !STOP
         ENDIF
      ENDDO


      END SUBROUTINE CHECK
!....................................................................

!--------------------------------------------------------------------
! Initilizing configuration
!--------------------------------------------------------------------
      SUBROUTINE INIT_FREC
      USE float_configuration; USE global_control; USE proc_par;
      USE ext_control_data;
      IMPLICIT NONE
      REAL*8,EXTERNAL :: RNDM, ANN
      REAL*8,ALLOCATABLE,DIMENSION(:) :: dse,wid_e
      REAL*8 :: anorma_free, diap, sdr
      INTEGER :: n

! Saving initial rendom generator seed for one attempt
      initial_k=k; PRINT*,"Initial_k = ",initial_k

! Setting normalization in specified range
      anorma_0 = norm_min + (norm_max-norm_min)*RNDM(k)
      DO i=1,sboi ; void = RNDM(k) ; ENDDO; ! Avoids correlations

! Initilize number of frequencies
      nmnm = min_in_fr + (max_in_fr-min_in_fr)*RNDM(k)
      ALLOCATE(dse(nmnm),wid_e(nmnm))
       DO i=1,sboi ; void = RNDM(k) ; ENDDO; ! Avoids correlations


! Initilizing anzac
      om_anz_0 = om_anz_min + (om_anz_max-om_anz_min)*RNDM(k)
      z_anz_0 = z_anz_min + (z_anz_max-z_anz_min)*RNDM(k)
      DO i=1,sboi ; void = RNDM(k) ; ENDDO; ! Avoids correlations

! Sugesting free frequencies
      sdr = 0.0
      DO n=1,nmnm
         dse(n) = RNDM(k) + (ato*nmnm) ;  sdr = sdr + dse(n)
         DO i=1,sboi ; void = RNDM(k) ; ENDDO; ! Avoids correlations
         DO
            om_0(n) = om_min + (om_max-om_min)*RNDM(k)
            diap = MIN(om_max-om_0(n),om_0(n)-om_min)
            IF(diap>=sgw_abs) EXIT
         ENDDO
         DO i=1,sboi ; void = RNDM(k) ; ENDDO; ! Avoids correlations
         wid_e(n) = un2*(diap-sgw_abs)*RNDM(k)/10.0 + sgw_abs
      ENDDO

! Setting initial normalization for free frequencies
      anorma_free = anorma_0 - z_anz_0
! Stopping nonsens normalization
      IF(anorma_free<0.0d0)THEN;
          PRINT*,'Free norma initializing is negative'
      ENDIF

! Rescaling the weights to absolute normalization
      DO n=1,nmnm
      to_t0(n) = anorma_free * dse(n) / sdr
      ro_h0(n) = to_t0(n) / wid_e(n)
      ENDDO

! Forming best free configuration for free spectrum
      nmnmb = nmnm ; om_b = om_0 ; to_tb = to_t0 ; ro_hb = ro_h0
      anorma_b = anorma_0
! Forming best configuration for anzac
      om_anz_b = om_anz_0 ; z_anz_b = z_anz_0

! Calculating deviations for initilized configuration
      z_best = &
      ANN(om_anz_b,z_anz_b,om_b,ro_hb,to_tb,anorma_b,nmnmb,.true.,-1)
      z_b_old = z_best ; buli = z_best

      PRINT*,'Number of frequencies in new set: ',nmnmb
      PRINT*,"Objective function of new spectrum = ",1/z_best

! Writing report of the initial configuration
      CALL HISTO_FORM(.TRUE.)
      OPEN(UNIT=4,FILE="init_hist.dat")
      DO i=0,num_his ;
          WRITE(4,*)om_grid(i)+sh_his/un2 , hi_flo(i)
      ENDDO
      CLOSE(4)
      CALL CHECK(-100,.TRUE.)

      DEALLOCATE(dse,wid_e)

      END SUBROUTINE INIT_FREC
!....................................................................

!--------------------------------------------------------------------
! Initilizing configuration for refinement
!--------------------------------------------------------------------
      SUBROUTINE INIT_REFINED_FREC
      USE useful_parameters; USE float_configuration
      USE global_control; USE ext_control_data;
      USE time_data
      IMPLICIT NONE
      REAL*8,DIMENSION(8) :: ahh

      REAL*8,EXTERNAL :: ANN,RNDM

      REAL*8 :: old_norma,new_norma,z_ku,om_anz_s,z_anz_s
      INTEGER :: i_glo_refsuc,iak,sliva,nmnms
      INTEGER,DIMENSION(10) :: akula

      OPEN(UNIT=4,FILE='glo_run.dat')
      READ(4,*)ivoid,ivoid,i_glo_refsuc;
      CLOSE(4)

      OPEN(UNIT=8,FILE='glo_each.dat');
      DO j=1,i_glo_refsuc
         READ(8,'(8(ES18.11,1X),I5)')ahh(1:8),cnm_of(j);
         cpo_of(j,1:8)=ahh(1:8)
      ENDDO
      CLOSE(8)

      OPEN(UNIT=4,       FILE='glo_conf.dat' ,ACCESS='direct', &
            RECL=conf_init, FORM='unformatted')

      om_anz_0=0.0; z_anz_0=0.0
      sliva=0

      DO iak=1,confi_mix
         akula(iak)=RNDM(k)*i_glo_refsuc+1
         void=RNDM(k); void=RNDM(k); void=RNDM(k)
         IF(akula(iak)>i_glo_refsuc)akula(iak)=i_glo_refsuc
         READ(4,REC=akula(iak))nmnms, &
         om_3(1:nmnms),to_t3(1:nmnms),ro_h3(1:nmnms)
         om_0(sliva+1:sliva+nmnms) =om_3(1:nmnms)
         to_t0(sliva+1:sliva+nmnms)=to_t3(1:nmnms)/confi_mix
         ro_h0(sliva+1:sliva+nmnms)=ro_h3(1:nmnms)/confi_mix
         sliva=sliva+nmnms
! anzac elaboration
         om_anz_s=cpo_of(akula(iak),4);
         z_anz_s=cpo_of(akula(iak),5);
         om_anz_0=om_anz_0+om_anz_s*z_anz_s
         z_anz_0=z_anz_0+z_anz_s/confi_mix
! Printing diagnostic data
         z_ku = &
         ANN(om_anz_0,z_anz_0,om_3,ro_h3,to_t3,anorma_0,nmnms,.true.,-1)
         PRINT*,'======================================='
         PRINT*,' Configuration number: ',akula(iak)
         PRINT*,' Frequencies number  : ',nmnms
         PRINT*,' Free total          : ',SUM(to_t3(1:nmnms))
         PRINT*,' Anzac weight      : ',cpo_of(akula(iak),5)
         PRINT*,' Total weight        : ', &
                 cpo_of(akula(iak),5)+SUM(to_t3(1:nmnms)), &
                 cpo_of(akula(iak),6)
         PRINT*,' Objective   : ', 1/(z_ku+1.0d-100)
      ENDDO
      CLOSE(4)

! Defining the final anzaces frequency
      IF(z_anz_0>1.0d-5) THEN
       om_anz_0=om_anz_0/(z_anz_0*confi_mix);
      ELSE
       om_anz_0=0.0d0
      ENDIF


      nmnm=sliva

      anorma_0=un1


! forming best anzac_1 configuration
      om_anz_b = om_anz_0 ; z_anz_b = z_anz_0

      old_norma=SUM(to_t0(1:nmnm))
      new_norma=SUM(to_t0(1:nmnm))

      PRINT*,'*******************************************'
      PRINT*,' Number of frequencies: ',nmnm
      PRINT*,' Anzac 1 weight     : ',z_anz_0
      PRINT*,' Norma          : ',new_norma+z_anz_0
      PRINT*,'*******************************************'

! forming best free configuration
      nmnmb = nmnm ;
      om_b(1:nmnmb) = om_0(1:nmnmb)
      to_tb(1:nmnmb) = to_t0(1:nmnmb)
      ro_hb(1:nmnmb) = ro_h0(1:nmnmb)
      anorma_b = anorma_0
      z_best = &
      ANN(om_anz_b,z_anz_b,om_b,ro_hb,to_tb,anorma_b,nmnmb,.true.,-1)
      z_b_old = z_best ; buli = z_best


      CALL HISTO_FORM(.TRUE.);  CALL REF_WRITE

      PRINT*,'------- REFINED FREQUENCIES SET IS INITIATED --------'
      PRINT*,'Objective  :',1.0/(z_best+1.0d-100)


      END SUBROUTINE INIT_REFINED_FREC
!....................................................................

!--------------------------------------------------------------------
! Performing reparametrizatio of configuration and runs consistent constraint
!--------------------------------------------------------------------
      SUBROUTINE DATA_TO_KOL
      USE proc_par; USE global_control; USE ext_control_data
      USE float_configuration; USE time_data;
      IMPLICIT NONE

      REAL*8,EXTERNAL :: ANN
      LOGICAL :: inside_run
      REAL*8 :: buli_1, do_togo, posle_togo, get_better
      INTEGER :: anzac_number, o_flag, nmnm_count, Nyyt


          inside_run=.TRUE.
          IF(print_additional)THEN
             PRINT*,"**** UDACHA UDACHA UDACHA *******"
          ENDIF
          buli_1 = &
          ANN(om_anz_0,z_aNZ_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.true.,-1)
          do_togo = 1.0d0/buli_1
          IF(print_additional)THEN
             PRINT*, &
            "My start before consistent constraints: ",1.0d0/buli_1
          ENDIF
          CALL NIKO_LAY
          IF(yes_anzac)THEN; anzac_number=1;
          ELSE;                      anzac_number=0; ENDIF
          SELECT CASE(kernel_type)
          CASE(-100);           o_flag=0
          CASE DEFAULT;  o_flag=1
          END SELECT
          CALL CHECK(-250,.TRUE.)
          gmax=0.0d0
          SELECT CASE(kernel_type)
             CASE(0,1,2,3,6,7)
                Nyyt=Nt
                gubar(1:Nt)=gr(1:Nt)
                sigmar(1:Nt)=sigma(1:Nt)
                tagar(1:Nt)=ta(1:nt)
                !print*,sigmar(1:Nt); PAUSE
             CASE(4,5)
                Nyyt=2*Nt 
                gubar(1:nt)          = G_inp_re(1:nt)
                gubar(nt+1:nt+nt) = G_inp_im(1:nt)
                sigmar(1:nt)          = sigma(1:nt)
                sigmar(nt+1:nt+nt) = sigma(1:nt)
                tagar(1:nt)          = ta(1:nt)
                tagar(nt+1:nt+nt) = ta(1:nt)
             END SELECT       
           !IF(kernel_type/=6)THEN  !CC exclusion when new kernel is tested
          CALL GRAD_Kolya(Nyyt,tagar,gubar,sigmar,anzac_number,N_nmnm, &
            N_om_0,N_ro_h0,Ka_Kol,gmax,inside_run,N_om_le,N_om_ri, &
            o_flag)
            !ENDIF
          IF(gmax>1.0d-20)THEN
             maxi_height=gmax
          ELSE
             maxi_height=maxi_height_0
          ENDIF
          IF(print_additional)THEN
             PRINT*,"MAXI HEIGHT = ",maxi_height
          ENDIF
          DO i=-1,num_his_hei+1
              hi_flo_hei(i)=maxi_height
          ENDDO
          DO i=NACALO_free,N_nmnm
             N_to_t0(i) = N_ro_h0(i) * (N_om_ri(i)-N_om_le(i))
          ENDDO
          IF(yes_anzac)THEN
              om_anz_0=N_om_0(1);  z_anz_0 =N_ro_h0(1)
          ENDIF
          nmnm_count=0
          DO i=NACALO_free,N_nmnm
             IF(N_ro_h0(i)>1.0d-20)THEN
                 nmnm_count=nmnm_count+1
                 om_sh(nmnm_count)=N_om_0(i)
                 ro_h_sh(nmnm_count)=N_ro_h0(i)
                 to_t_sh(nmnm_count)=N_to_t0(i)
             ENDIF
          ENDDO
          nmnm=nmnm_count
          DO i=1,nmnm_count
              om_0(i)=om_sh(i)
              ro_h0(i)=ro_h_sh(i)
              to_t0(i)=to_t_sh(i)
          ENDDO
          buli = &
          ANN(om_anz_0,z_anz_0,om_0,ro_h0,to_t0,anorma_0,nmnm,.true.,-1)
          CALL HISTO_FORM(.TRUE.)
          posle_togo = 1.0d0/buli
          get_better =  do_togo/posle_togo !Nice if >1, posle_togo<do_togo
          IF(i_pomog<imax_pomog)THEN
             i_pomog = i_pomog + 1
             Pomog(i_pomog,1) = posle_togo; 
             Pomog(i_pomog,2) = get_better
          ENDIF   
          PRINT*,"Posle: ",posle_togo,"  Improved: ",get_better 
          OPEN(UNIT=4,FILE="init_hist.dat")
          DO i=0,num_his ;
          WRITE(4,*)om_grid(i)+sh_his/un2 , hi_flo(i)
          ENDDO
          CLOSE(4)
          CALL CHECK(-200,.TRUE.)
          IF(print_additional)THEN
          PRINT*,"My end after consistent constraint: ", &
                      1.0d0/(buli+1.0d-100)
          ENDIF

      END SUBROUTINE DATA_TO_KOL
!....................................................................

!--------------------------------------------------------------------
! Performing reparametrizatio of configuration
!--------------------------------------------------------------------
      SUBROUTINE NIKO_LAY
      USE float_configuration ; USE proc_par
      USE global_control ; USE ext_control_data ; USE time_data
      IMPLICIT NONE
      REAL*8,EXTERNAL :: EX,AKKA
      REAL*8 :: Niko_norm_1, Niko_norm_2, cuti
      REAL*8,ALLOCATABLE,DIMENSION(:) :: om_l, om_r
      REAL*8,ALLOCATABLE,DIMENSION(:) :: gg_gg
      COMPLEX*16,ALLOCATABLE,DIMENSION(:) :: gg_gg_MA

      ALLOCATE(om_l(5*nf_max),om_r(5*nf_max))
      SELECT CASE(kernel_type)
      CASE(0,1,2,3,6);  ALLOCATE(gg_gg(nt))
      CASE(4,5);       ALLOCATE(gg_gg_MA(nt))
      END SELECT

      N_nmnm=0
      IF(z_anz_max>1.0d-20)THEN; yes_anzac=.TRUE.; ENDIF
      IF(yes_anzac)THEN
         N_nmnm=N_nmnm+1
         N_om_0(N_nmnm)=om_anz_0; N_ro_h0(N_nmnm)=z_anz_0;
         N_to_t0(N_nmnm)=z_anz_0;
      ENDIF
!First frequency
      NACALO_free=N_nmnm+1; N_nmnm=NACALO_free
      N_om_0(N_nmnm)=om_0(1); N_ro_h0(N_nmnm)=ro_h0(1);
      N_to_t0(N_nmnm)=to_t0(1)
      N_om_le(N_nmnm)=om_le(1); N_om_ri(N_nmnm)=om_ri(1)
!Further if nmnm>1
      IF(nmnm>1)THEN
        DO i=2,nmnm
          IF(om_le(i)>om_ri(i-1) .AND. &
            ABS(om_le(i)-om_ri(i-1))>1.0d-12)THEN
              !empty space
              N_nmnm=N_nmnm+1;
              N_om_le(N_nmnm)=om_ri(i-1); N_om_ri(N_nmnm)=om_le(i)
              N_om_0(N_nmnm) = 0.5d0*(N_om_le(N_nmnm)+N_om_ri(N_nmnm))
              N_ro_h0(N_nmnm)=0.0d0; N_to_t0(N_nmnm)=0.0d0
              !existing frequency
              N_nmnm=N_nmnm+1;
              N_om_le(N_nmnm)=om_le(i); N_om_ri(N_nmnm)=om_ri(i)
              N_om_0(N_nmnm) = om_0(i)
              N_ro_h0(N_nmnm)=ro_h0(i); N_to_t0(N_nmnm)=to_t0(i)
          ELSE
              N_nmnm=N_nmnm+1;
              N_om_le(N_nmnm)=om_le(i); N_om_ri(N_nmnm)=om_ri(i)
              N_om_0(N_nmnm) = om_0(i)
              N_ro_h0(N_nmnm)=ro_h0(i); N_to_t0(N_nmnm)=to_t0(i)
          ENDIF
        ENDDO
      ENDIF

      Niko_norm_1=0.0d0; Niko_norm_2=0.0d0
      DO i=NACALO_free,N_nmnm
         Niko_norm_1=Niko_norm_1+N_to_t0(i)
         Niko_norm_2=Niko_norm_2+N_ro_h0(i)*(N_om_ri(i)-N_om_le(i))
      ENDDO
      Niko_norm_1=Niko_norm_1+z_anz_0
      Niko_norm_2=Niko_norm_2+z_anz_0
!      PRINT*,"N_nmnm = ",N_nmnm
!      PRINT*,"N_Niko_norms:", NIko_norm_1,Niko_norm_2


! Preparing kernel "tutu" for Kolya
! KERNEL_GDE
      SELECT CASE(kernel_type)

         CASE(0) ! T=0

            DO j=1,nt
               IF(yes_anzac)THEN
                  Ka_Kol(j,1) = EX(-ta(j)*om_anz_0)
               ENDIF
               DO i=NACALO_free,N_nmnm
                  IF(ta(j)<1.0d-12)THEN
                     Ka_Kol(j,i)=N_om_ri(i)-N_om_le(i)
                  ELSE
                     Ka_Kol(j,i) = ( 1.0d0 / ta(j) ) * &
                    ( EX(-ta(j)*N_om_le(i) ) - EX(-ta(j)*N_om_ri(i) ) )
                  ENDIF
                  IF(Ka_Kol(j,i)<=0.0d0)THEN
                      !PRINT*,"Chto Kole to dal?"
                      !PRINT*,i,j,Ka_kol(i,j); STOP
                  ENDIF
               ENDDO
            ENDDO

         CASE(1) ! OC finite T

            DO j=1,nt
               IF(yes_anzac)THEN
                  STOP"NO anzac in OC anacon!"
               ENDIF
               DO i=NACALO_free,N_nmnm
                  Ka_Kol(j,i) = &
                    AKKA(j,N_om_ri(i),  N_om_le(i)) + &
                    AKKA(j,-N_om_le(i),-N_om_ri(i))   
                  !IF(Ka_Kol(j,i)<1.0d-25)Ka_Kol(j,i)=1.0d-25
               ENDDO
            ENDDO

         CASE(2,3) ! Fermi and Symmetric-Bose for imaginary time

             DO j=1,nt
               IF(yes_anzac)THEN
                  STOP"NO anzac in Fermi/Bose finite T made!"
               ENDIF
               DO i=NACALO_free,N_nmnm
                  Ka_Kol(j,i) = &
                    AKKA(j,N_om_ri(i),  N_om_le(i))
                  !IF(Ka_Kol(j,i)<1.0d-25)Ka_Kol(j,i)=1.0d-25
               ENDDO
            ENDDO

         CASE(4,5) ! Fermi and Bose Matsubara

            DO j=1,nt
               IF(yes_anzac)THEN
                  STOP"NO anzac in Fermi/Bose Matsubara made!"
               ENDIF
               DO  i=NACALO_free,N_nmnm
                  Ka_Kol(j,i) = &
                    REAL(LOG(  (N_om_ri(i)-Om_input(j)) / &
                                     (N_om_le(i)-Om_input(j))   )  )
                  Ka_Kol(j+nt,i) = &
                    IMAG(LOG(  (N_om_ri(i)-Om_input(j)) / &
                                     (N_om_le(i)-Om_input(j))   )  )
                  Ka_Kol_MA(j,i) = DCMPLX(Ka_Kol(j,i),Ka_Kol(j+nt,i))
               ENDDO
            ENDDO

         CASE(6)
             
            DO j=1,nt
               IF(yes_anzac)THEN
                  cuti=ta(j)*om_anz_0 
                  IF(j<=nt_d2)THEN  
                     Ka_Kol(j,1) =   EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                  ELSE
                     Ka_Kol(j,1) = - EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                  ENDIF 
               ENDIF
               DO i=NACALO_free,N_nmnm
                  Ka_Kol(j,i) = &
                    AKKA(j,N_om_ri(i),  N_om_le(i))
               ENDDO
            ENDDO

         CASE(7)
             
            DO j=1,nt
               IF(yes_anzac)THEN
                  cuti=ta(j)*om_anz_0 
                  IF(nt_d2>0)THEN
                     IF(j<=nt_d2)THEN  
                        Ka_Kol(j,1) =   EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                     ELSE IF(j>nt_d2 .AND. j<=nt_compl)THEN
                        Ka_Kol(j,1) = - EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                     ELSE IF(j<nt_compl .AND. j<nt)THEN
                        Ka_Kol(j,1) = EX(-cuti)
                     ENDIF   
                  ELSE
                     Ka_Kol(j,1) = EX(-cuti) 
                  ENDIF    
               ENDIF
               DO i=NACALO_free,N_nmnm
                  Ka_Kol(j,i) = &
                    AKKA(j,N_om_ri(i),  N_om_le(i))
               ENDDO
            ENDDO
            
         CASE DEFAULT

            STOP"Such kernel is not yet introduced"

         END SELECT

!     Control for correctness of the Kernel transmission
      SELECT CASE(kernel_type)

      CASE(0,1,2,3)

         gg_gg(1:nt)=0.0d0
         DO j=1,nt; DO i=Nacalo_free,N_nmnm;
            gg_gg(j)=gg_gg(j)+Ka_Kol(j,i)*N_ro_h0(i)
         ENDDO; ENDDO
         OPEN(UNIT=4,FILE="segg.dat")
            DO j=1,nt; WRITE(4,*)ta(j),LOG(gc(j)),LOG(gg_gg(j))
            ENDDO
         CLOSE(4)

      CASE(4,5)

         gg_gg_MA(1:nt)=DCMPLX(0.0d0,0.0d0)
         DO j=1,nt; DO i=Nacalo_free,N_nmnm;
            gg_gg_MA(j)=gg_gg_MA(j)+Ka_Kol_MA(j,i) * &
                                 DCMPLX(N_ro_h0(i),0.0d0)
         ENDDO; ENDDO
         OPEN(UNIT=4,FILE="segg.dat")
           DO j=1,nt;
              WRITE(4,*)j,REAL(gc_MA(j)),  REAL(gg_gg_MA(j)), &
                                     AIMAG(gc_MA(j)),AIMAG(gg_gg_MA(j))
           ENDDO
         CLOSE(4)

      CASE(6)
          
         gg_gg(1:nt)=0.0d0
         DO j=1,nt; DO i=Nacalo_free,N_nmnm;
            gg_gg(j)=gg_gg(j)+Ka_Kol(j,i)*N_ro_h0(i)
         ENDDO; ENDDO
         OPEN(UNIT=4,FILE="segg.dat")
            DO j=1,nt_d2; WRITE(4,*)ta(j),gc(j),gg_gg(j),gr(j)
            ENDDO
         CLOSE(4)

         OPEN(UNIT=4,FILE="segg_im.dat")
            DO j=nt_d2+1,nt; WRITE(4,*)ta(j),gc(j),gg_gg(j),gr(j)
            ENDDO
         CLOSE(4)
          
      END SELECT

      !PRINT*,Ka_Kol(1:nt,3)

      DEALLOCATE(om_l,om_r)
      SELECT CASE(kernel_type)
      CASE(0,1,2,3)
          DEALLOCATE(gg_gg)
      CASE(4,5)
          DEALLOCATE(gg_gg_MA)
      END SELECT

      END SUBROUTINE NIKO_LAY
!....................................................................


!--------------------------------------------------------------------
! Creating parameters for one LOCAL RUN
!--------------------------------------------------------------------
      SUBROUTINE LOCAL_RUN_PAR
      USE global_control ; USE ext_control_data ;
      IMPLICIT NONE
      hi_glob(0:num_his)=0.0d0; num_stat=0
      hi_flo_kol(0:num_his)=0.0d0; ! flo_kol
      hi_glob_big(0:num_his_big)=0.0d0;
! Putting process efficiency parameters to zero
      c_shi_full_e = 0; c_shi_full_o = 0 ; co_shi_full = 0
      c_ex_z_e = 0; c_ex_z_o = 0 ; co_ex_z = 0
      c_wid_ch_e = 0; c_wid_ch_o = 0 ; co_wid_ch = 0
      c_shi_two_e = 0; c_shi_two_o = 0 ; co_shi_two = 0
      co_spl_born = 0; c_spl_born_e = 0; c_spl_born_o = 0
      co_glue = 0; c_glue_e = 0; c_glue_o = 0
      co_vert = 0; c_vert_e = 0; c_vert_o = 0
      co_shi_anz1 = 0; c_shi_anz1_e = 0; c_shi_anz1_o = 0
      co_ex_anz1 = 0; c_ex_anz1_e = 0; c_ex_anz1_o = 0
      co_upd=0; c_alt=0; c_bor=0; c_del=0

      END SUBROUTINE LOCAL_RUN_PAR
!....................................................................

!--------------------------------------------------------------------
! Creating scratch data for one STEP
!--------------------------------------------------------------------
      SUBROUTINE STEP_SCRATCH(ij)
      USE float_configuration; USE proc_par;
      USE ext_control_data; IMPLICIT NONE
      INTEGER,INTENT(IN) :: ij

! Setting configuration for extrapolation
      om_1(1:nmnm)=om_0(1:nmnm)
      ro_h1(1:nmnm)=ro_h0(1:nmnm) ; to_t1(1:nmnm)=to_t0(1:nmnm)
      om_2(1:nmnm)=om_0(1:nmnm)
      ro_h2(1:nmnm)=ro_h0(1:nmnm) ; to_t2(1:nmnm)=to_t0(1:nmnm)
      om_3(1:nmnm)=om_0(1:nmnm)
      ro_h3(1:nmnm)=ro_h0(1:nmnm) ; to_t3(1:nmnm)=to_t0(1:nmnm)

      IF(ij<n_cikl/4)THEN
           afe = afe_glo              ! Moderate resistance to jumps bacl
      ELSE IF(ij>=n_cikl/4 .AND. ij<n_cikl/2)THEN
           afe = 50 * afe_glo       ! Weak resistance to jumps back
      ELSE IF(ij>=(3*n_cikl)/4)THEN
           afe = afe_glo/10.0d0    ! Strong resistance to jumps back
      ENDIF

      END SUBROUTINE STEP_SCRATCH
!....................................................................

!--------------------------------------------------------------------
! Creating parameters for one global update
!--------------------------------------------------------------------
      SUBROUTINE ONE_LOOP_PAR
      USE proc_par; USE global_control; USE ext_control_data
      USE float_configuration;
      IMPLICIT NONE

      REAL*8,EXTERNAL :: RNDM, ANN
      LOGICAL :: Udacha
      REAL*8 :: zzz, cuca, buba, rtf, yg

! Defining level for JumpsBack Resistance: afe>>1 is weak
! resistance to JumpsBack and afe<<1 is strong resistance
      afe_glo = afemin + (afemax-afemin)*(RNDM(k)**trah)

! Defining scale for suggestion of change in updates in range [0,1]
! Larger probability for capur << 1 then to capur ~ 1.
      zzz = RNDM(k) ; cuca = capu_max - un1
      buba = zzz + (1-zzz)/(capu_min**cuca)
      capur = un1 / buba**(un1/cuca)

! Defining number of cikles for one loop
      n_cikl = n_cikl0*RNDM(k)+1

! Defining scale of exachage of weights betweem anzac and free spectrum
      batura=16.0*RNDM(k)*RNDM(k)*RNDM(k)*RNDM(k)

! Defining float configurations from the best on the previous LOOP
      nmnm = nmnmb ;               om_0(1:nmnm)=om_b(1:nmnm)
      to_t0(1:nmnm)=to_tb(1:nmnm); ro_h0(1:nmnm)=ro_hb(1:nmnm)
      om_anz_0 = om_anz_b ; z_anz_0 = z_anz_b               !anzac_1 float
      anorma_0=anorma_b
! Defining to save configuration from the best on the previous LOOP
! to return back in case of big cikle effect
      nmnm_sav = nmnmb ;               om_0_sav(1:nmnm)=om_b(1:nmnm)
      to_t_sav(1:nmnm)=to_tb(1:nmnm); ro_h_sav(1:nmnm)=ro_hb(1:nmnm)
      om_anz_sav = om_anz_b ; z_anz_sav = z_anz_b               !anzac_1 float
      anorma_sav=anorma_b

!Defining inverse deviation before
      chuki_do = &
      ANN(om_anz_b,z_anz_b,om_b,ro_hb,to_tb,anorma_b,nmnmb,.true.,-1)

      buli = chuki_do
! Defining former best deviation before LOOP started
      z_b_old = z_best

! Defining probabilities aduva for birdth (1), death (2), alter(3)
      aduva(3)=alt_pr+(un1-alt_pr)*RNDM(k)
      rtf=REAL(nmnmb)/nf_max
      IF(rtf<=un1)THEN
        yg=mi_ra+rtf*(ma_ra-mi_ra)
        aduva(1)=(un1-aduva(3))/(un1+yg); aduva(2)=yg*aduva(1)
      ELSE
        yg=1000.0
        aduva(1)=(un1-aduva(3))/(un1+yg); aduva(2)=yg*aduva(1)
      ENDIF
      proc0(1)=aduva(1);proc0(2)=proc0(1)+aduva(2)
      !PRINT*,nmnmb
      !PRINT*,'PROC0: ',proc0(0:2)

! Perform vertical slicing before making global update
      CALL vert_slice(Udacha)

      END SUBROUTINE ONE_LOOP_PAR
!....................................................................

!--------------------------------------------------------------------
! Prints after num_skiop attempts, num_skip is defines in module ext_control_data
!--------------------------------------------------------------------
      SUBROUTINE ONE_LOOP_PRINT(global)
      USE proc_par; USE global_control; USE ext_control_data
      USE float_configuration; USE time_data
      IMPLICIT NONE
      REAL*8 :: BukaShiki

      LOGICAL,INTENT(IN) :: global

      REAL*8,EXTERNAL :: ANN
      REAL*8 :: ch,defect
      INTEGER :: iiii

! Skip printing untill counter "i_skip" reaches "num_skip"
      i_skip=i_skip+1
      IF(i_skip/=num_skip)THEN
         RETURN
      ELSE
         i_skip=0
         CALL HISTO_FORM(.TRUE.)
         ch = &
        ANN(om_anz_b,z_anz_b,om_b,ro_hb,to_tb,anorma_b,nmnmb,.true.,-1)
         defect=(ch-z_best)/(ch+z_best)
! KERNEL_GDE
         SELECT CASE(kernel_type)
             CASE(0,1,2,3)
                 deviation(1:nt) = &
                 (gc_global(1:nt)-gr(1:nt))/(sigma(1:nt)*gr(1:nt))
                 deviation_glob(1:nt)=deviation(1:nt)
             CASE(4,5)
                 deviation(1:nt) = &
                 REAL( gc_global_MA(1:nt)-G_input(1:nt) ) / &
                      (ABS(sigma(1:nt)*G_input(1:nt))) 
                 deviation_im(1:nt) = &
                 IMAG( gc_global_MA(1:nt)-G_input(1:nt) ) / &
                      (ABS(sigma(1:nt)*G_input(1:nt))) 
                 deviation_glob(1:nt)=deviation(1:nt)
                 deviation_glob(nt+1:2*nt)=deviation_im(1:nt)
             CASE(6)
                 deviation(1:nt_d2)= &
                 (gc_global(1:nt_d2)-gr(1:nt_d2))/ABS(sigma(1:nt))
                 deviation_im(1:nt_d2)= &
                 (gc_global(nt_d2+1:nt)-gr(nt_d2+1:nt))/ABS(sigma(nt_d2+1:nt))
                 deviation_glob(1:nt_d2)=deviation(1:nt_d2)
                 deviation_glob(nt_d2+1:nt)=deviation_im(1:nt_d2)
             CASE(7)
                 deviation(1:nt_d2)= &
                 (gc_global(1:nt_d2)-gr(1:nt_d2))/ABS(sigma(1:nt_d2))
                 deviation_glob(1:nt_d2) = deviation(1:nt_d2)
                 deviation_im(1:nt_d2)= &
                 (gc_global(nt_d2+1:nt_compl)-gr(nt_d2+1:nt_compl))/ABS(sigma(nt_d2+1:nt_compl))
                  deviation_glob(nt_d2+1:nt_compl) = deviation_im(1:nt_d2)
                  deviation_imatau(1:nt_imag)= &
                 (gc_global(nt_compl+1:nt)-gr(nt_compl+1:nt))/ABS(sigma(nt_compl+1:nt))
                  deviation_glob(nt_compl+1:nt) = deviation_imatau(1:nt_imag)
        END SELECT        
         kappa = 0.0d0
         DO iiii=1,nt-1
            IF( (deviation_glob(iiii)*deviation_glob(iiii+1)) < 0.0d0 )THEN
               kappa =  kappa + 1.0d0
            ENDIF
         ENDDO
         kappa = kappa / (nt-1)
         IF(write_loop/=0)  CALL LOOP_WRITE
      ENDIF

! Doing below if decided to print out

      deviation_glob(1:nt)=ABS(deviation_glob(1:nt))**2
      max_deviation = MAXVAL(deviation_glob(1:nt))
      ave_deviation = SUM(ABS(deviation_glob(1:nt)))/(nt)
      kurik=z_anz_b+SUM(to_tb(1:nmnmb))

      poluchil(1:N_Nikolay) = nastupil(1:N_Nikolay)/zaludil
      BukaShiki = KakaShiki/SUM(nastupil(1:N_Nikolay)+1.0d-12)

      PRINT*,"====xenon_02=====2015.07.28==16:32=Wako========"
      IF(refinement/=0)THEN
         PRINT*,' +++++++++ REFINEMENT ++++++++++++++++++++++++'
      ENDIF
!KERNEL_GDE
      SELECT CASE(kernel_type)
         CASE(0)
          PRINT*,"+++++++++ T=0 inaginary time kernel ++++++++++"
         CASE(1)
          PRINT*,"+++++ Optical conductivity imaginary time kernel +++++"
         CASE(2)
          PRINT*,"++++++++ Fermi  imaginary time kernel++++++++"
         CASE(3)
          PRINT*,"+++++++ Phonon imaginry time kernel ++++++++"
         CASE(4)
          PRINT*,"+++++++++++ Femi Matsubara kernel ++++++++++"
         CASE(5)
          PRINT*,"+++++++++++ Bose Matsubara kernel ++++++++++"
         CASE(6)
          PRINT*,"+++++++++++ Complex time kernel ++++++++++"
         CASE(7)
          PRINT*,"++Joint complex+imaginary time kernel ++++++++++"
      END SELECT    
      PRINT"('  RUN =',I5,'   SUCCES=',I5,'   MAXRUN=',I5)", &
       i_glo_run,i_glo_suc,max_glo_run
      PRINT"('  LOOP=',I5,'   MAXLOC=',I5,'   n_cikl=',I5)", &
       i_loc_run,hvatit,n_cikl
      PRINT"('  nmnmb=',i5,'  DEFECT=     ',ES11.4)", &
       nmnmb,defect/ch
      PRINT"('  Omega =',ES14.7,'  Z  =  ',ES14.7)", &
              om_anz_0,z_anz_0
      IF(global)THEN
         PRINT"('  Objective: ',ES10.3, '  Kappa: ' &
        ,ES10.3, '  Ratio: ',ES10.3)", &
        1/(ch+1.0d-100),kappa,best_dev/(ch+1.0d-100)
      ELSE
         PRINT"('  Objective: ',ES10.3, '  Kappa: ',ES10.3)", &
        1/(ch+1.0d-100),kappa
      ENDIF
      IF(kernel_type==7)THEN
         PRINT"('  Complex  : ',ES10.3, '  Imaginary: ',ES10.3)", &
         object_complex,object_imaginary          
      ENDIF    
      PRINT*,'---------------- EFFICIENCY OF PROCESSES -----------'
      !PRINT*,'1'
      PRINT"('Zaludil =',ES10.3,' Udalos    =  ',10(1X,F5.2,1X))", &
              zaludil,poluchil(1:N_Nikolay)
      !PRINT*,'2'
      PRINT"('KakaShiki =',ES10.3,' KakaShiki_rel =',ES10.3)", &
              KakaShiki,BukaShiki
      !PRINT*,'3'
      PRINT"('alter/born/del: <',F5.2,'> <',F5.2,'> <',F5.2,'> ')", &
       (100*c_alt)/(co_upd+0.1d0), (100*c_bor)/(co_upd+0.1d0), &
       (100*c_del)/(co_upd+0.1d0)
      PRINT"('shi_full: <',F5.2,'> <',F5.2,'>' &
                '    ex_z:      <',F5.2,'> <',F5.2,'>')", &
      REAL(100*c_shi_full_e)/(co_shi_full+0.1), &
      REAL(100*c_shi_full_o)/(co_shi_full+0.1), &
      REAL(100*c_ex_z_e)/(co_ex_z+0.1),   &
      REAL(100*c_ex_z_o)/(co_ex_z+0.1) 
      PRINT"('shi_two:  <',F5.2,'> <',F5.2,'>' &
                '    wid_ch:    <',F5.2,'> <',F5.2,'>')", &
      REAL(100*c_shi_two_e)/(co_shi_two+0.1), &
      REAL(100*c_shi_two_o)/(co_shi_two+0.1), &
      REAL(100*c_wid_ch_e)/(co_wid_ch+0.1), &
      REAL(100*c_wid_ch_o)/(co_wid_ch+0.1)
      PRINT"('   spl_bor: <',F5.2,'> <',F5.2,'>' &
                '      glue:   <',F5.2,'> <',F5.2,'>')", &
      REAL(100*c_spl_born_e)/(co_spl_born+0.1), &
      REAL(100*c_spl_born_o)/(co_spl_born+0.1), &
      REAL(100*c_glue_e)/(co_glue+0.1), &
      REAL(100*c_glue_o)/(co_glue+0.1)
      PRINT"('vert:     <',F5.2,'> <',F5.2,'>' &
                 '    vert:      <',F5.2,'> <',F5.2,'>')", &
      REAL(100*c_vert_e)/(co_vert+0.1), &
      REAL(100*c_vert_o)/(co_vert+0.1), &
      REAL(100*c_vert_e)/(co_vert+0.1), &
      REAL(100*c_vert_o)/(co_vert+0.1)
      PRINT"('shi_anz1: <',F5.2,'> <',F5.2,'>' &
                '  ex_anz1:     <',F5.2,'> <',F5.2,'>')", &
      REAL(100*c_shi_anz1_e)/(co_shi_anz1+0.1), &
      REAL(100*c_shi_anz1_o)/(co_shi_anz1+0.1), &
      REAL(100*c_ex_anz1_e)/(co_ex_anz1+0.1), &
      REAL(100*c_ex_anz1_o)/(co_ex_anz1+0.1)
      IF(print_control)THEN
         PRINT"('Improve fail: ',ES10.3,'    Norma fail: ',ES10.3)",&
              duha_chu/(duha_all+1.0d-20), duha_nor/(duha_all+1.0d-20)
         PRINT"('Ranges  fail: ',ES10.3,'    NuFre fail: ',ES10.3)",&
              duha_ran/(duha_all+1.0d-20), duha_num/(duha_all+1.0d-20)
      ENDIF    
      PRINT*,"                                             "
      END SUBROUTINE ONE_LOOP_PRINT
!....................................................................

!--------------------------------------------------------------------
! Performing printout and analisis of one loop run
!--------------------------------------------------------------------
      SUBROUTINE STAT_ADD(gotovo)
      USE float_configuration; USE global_control; USE ext_control_data
      IMPLICIT NONE
      LOGICAL,INTENT(OUT) :: gotovo

      gotovo=.false.

      IF(z_best>stat_dev)THEN
         CALL HISTO_FORM(.TRUE.); num_stat=num_stat+1
         hi_glob(0:num_his)=hi_glob(0:num_his)+hi_flo(0:num_his)
         hi_glob_big(0:num_his_big)=hi_glob_big(0:num_his_big) &
                                        +hi_flo_big(0:num_his_big)
         IF(z_best>best_dev) gotovo=.true.
      ENDIF

      END SUBROUTINE STAT_ADD
!....................................................................

!--------------------------------------------------------------------
!     Creating histogram for best configuration
!--------------------------------------------------------------------
      SUBROUTINE HISTO_FORM(bestiki)
      USE ext_control_data    ; USE global_control
      USE float_configuration ;
      IMPLICIT NONE
      LOGICAL,INTENT(IN) :: bestiki

      INTEGER :: ifw, ih, i_str, i_hi, i_anz, nmnm_tuti
      REAL*8 :: alef, arig, alef_0, arig_0, miva, pom_0, pro_h0, pto_t0
      REAL*8 :: width, zyt_l, zyt_r

!      PRINT*,"Starts histogram"

      hi_flo(0:num_his)        = 0.0d0

      IF(bestiki)THEN
         nmnm_tuti=nmnmb
      ELSE
         nmnm_tuti=nmnm ! flo_kol
      ENDIF

! Small spectrum below: narrow histogram
! creating histogram for free spectrum
      DO ih = 1 , nmnm_tuti
         IF(bestiki)THEN
            pom_0=om_b(ih) ; pro_h0=ro_hb(ih) ; pto_t0=to_tb(ih)
         ELSE
            pom_0=om_0(ih) ; pro_h0=ro_h0(ih) ; pto_t0=to_t0(ih) ! flo_kol
         ENDIF
         width = (pto_t0/pro_h0)
         alef_0 = pom_0 - width/un2 ; arig_0 = pom_0 + width/un2
         alef=alef_0 ;arig=arig_0
         i_str = (((alef-his_min)*num_his)/(his_max-his_min))
         i_hi  = (((arig-his_min)*num_his)/(his_max-his_min))
         ! Avoiding outside points ---------------------------------------
         IF(i_hi<0)THEN;                    CYCLE
         ELSE IF(i_str>num_his)THEN;  CYCLE
         ELSE;
               IF(i_str<0)THEN
                    i_str=-1;          alef=om_grid(0)-sh_his
               ENDIF
               IF(i_hi>num_his)THEN
                    i_hi=num_his+1; arig=om_grid(num_his)+sh_his
               ENDIF
         ENDIF
         ! Distributing weight to hystogram cells.............................
         IF(i_hi.eq.i_str) THEN
            hi_flo(i_str)=hi_flo(i_str)+pro_h0*(width/sh_his)
         ELSE IF(i_hi.eq.i_str+1) THEN
            zyt_l=(om_grid(i_str+1)-alef)/sh_his
            zyt_r=(arig-om_grid(i_hi))/sh_his
            IF(zyt_l>0.0d0)hi_flo(i_str)=hi_flo(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo(i_hi)=hi_flo(i_hi)+pro_h0*zyt_r
         ELSE
            zyt_l=(om_grid(i_str+1)-alef)/sh_his
            zyt_r=(arig-om_grid(i_hi))/sh_his
            IF(zyt_l>0.0d0)hi_flo(i_str)=hi_flo(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo(i_hi)=hi_flo(i_hi)+pro_h0*zyt_r
            DO ifw=i_str+1,i_hi-1
               hi_flo(ifw)=hi_flo(ifw)+pro_h0
            ENDDO
         ENDIF
      ENDDO
! Creating for free spectrum: mirroring spectrum if for OC
      mirror: IF(kernel_type==1)THEN; !Mirroring if for OC
      DO ih = 1 , nmnm_tuti
         IF(bestiki)THEN
            pom_0=om_b(ih) ; pro_h0=ro_hb(ih) ; pto_t0=to_tb(ih)
         ELSE
            pom_0=om_0(ih) ; pro_h0=ro_h0(ih) ; pto_t0=to_t0(ih)
         ENDIF
         width = (pto_t0/pro_h0)
         alef_0 = pom_0 - width/un2 ; arig_0 = pom_0 + width/un2
         alef=-arig_0; arig=-alef_0
         i_str = (((alef-his_min)*num_his)/(his_max-his_min))
         i_hi  = (((arig-his_min)*num_his)/(his_max-his_min))
         ! Avoiding outside points ---------------------------------------
         IF(i_hi<0)THEN;                    CYCLE
         ELSE IF(i_str>num_his)THEN;  CYCLE
         ELSE;
               IF(i_str<0)THEN
                    i_str=-1;          alef=om_grid(0)-sh_his
               ENDIF
               IF(i_hi>num_his)THEN
                    i_hi=num_his+1; arig=om_grid(num_his)+sh_his
               ENDIF
         ENDIF
         ! Distributing weight to the histogram cels........................................
         IF(i_hi.eq.i_str) THEN
            hi_flo(i_str)=hi_flo(i_str)+pro_h0*(width/sh_his)
         ELSE IF(i_hi.eq.i_str+1) THEN
            zyt_l=(om_grid(i_str+1)-alef)/sh_his
            zyt_r=(arig-om_grid(i_hi))/sh_his
            IF(zyt_l>0.0d0)hi_flo(i_str)=hi_flo(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo(i_hi)=hi_flo(i_hi)+pro_h0*zyt_r
         ELSE
            zyt_l=(om_grid(i_str+1)-alef)/sh_his
            zyt_r=(arig-om_grid(i_hi))/sh_his
            IF(zyt_l>0.0d0)hi_flo(i_str)=hi_flo(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo(i_hi)=hi_flo(i_hi)+pro_h0*zyt_r
            DO ifw=i_str+1,i_hi-1
               hi_flo(ifw)=hi_flo(ifw)+pro_h0
            ENDDO
         ENDIF
      ENDDO
      ENDIF mirror !Mirroring if for OC
! Small spectrum abowe: narrow histogram

      miva=MINVAL(hi_flo(0:num_his))
      IF(miva<0.0d0)THEN
         PRINT*,"SMAKUT:",miva; !STOP
      ENDIF

      hi_flo_big(0:num_his_big) = 0.0d0

! Big spectrum below: broad histogram
! creating histogram for free spectrum sigma_l
      DO ih = 1 , nmnmb
         pom_0=om_b(ih) ; pro_h0=ro_hb(ih) ; pto_t0=to_tb(ih)
         width = (pto_t0/pro_h0)
         alef_0 = pom_0 - width/un2 ; arig_0 = pom_0 + width/un2
         alef=alef_0 ;arig=arig_0
         i_str = (((alef-his_min_big)*num_his_big) &
                  /(his_max_big-his_min_big))
         i_hi  = (((arig-his_min_big)*num_his_big) &
                  /(his_max_big-his_min_big))
         ! Avoiding outside points ---------------------------------------
         IF(i_hi<0)THEN;                    CYCLE
         ELSE IF(i_str>num_his_big)THEN;  CYCLE
         ELSE;
               IF(i_str<0)THEN
                    i_str=-1;
                   alef=om_grid_big(0)-sh_his_big
               ENDIF
               IF(i_hi>num_his_big)THEN
                    i_hi=num_his_big+1;
                   arig=om_grid_big(num_his)+sh_his_big
               ENDIF
         ENDIF
         ! Distributing weight to histogram cells ........................................
         IF(i_hi.eq.i_str) THEN
            hi_flo_big(i_str)=hi_flo_big(i_str)+ &
                             pro_h0*(width/sh_his_big)
         ELSE IF(i_hi.eq.i_str+1) THEN
            zyt_l=(om_grid_big(i_str+1)-alef)/sh_his_big
            zyt_r=(arig-om_grid_big(i_hi))/sh_his_big
            IF(zyt_l>0.0d0) &
               hi_flo_big(i_str)=hi_flo_big(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0) &
               hi_flo_big(i_hi)=hi_flo_big(i_hi)+pro_h0*zyt_r
         ELSE
            zyt_l=(om_grid_big(i_str+1)-alef)/sh_his_big
            zyt_r=(arig-om_grid_big(i_hi))/sh_his_big
            IF(zyt_l>0.0d0) &
                hi_flo_big(i_str)=hi_flo_big(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0) &
                hi_flo_big(i_hi)=hi_flo_big(i_hi)+pro_h0*zyt_r
            DO ifw=i_str+1,i_hi-1
               hi_flo_big(ifw)=hi_flo_big(ifw)+pro_h0
            ENDDO
         ENDIF
      ENDDO
! creating histogram for free spectrum - mirroring spectrum
      mirror1: IF(kernel_type==1)THEN; !Mirroring if for OC
      DO ih = 1 , nmnmb
         pom_0=om_b(ih) ; pro_h0=ro_hb(ih) ; pto_t0=to_tb(ih)
         width = (pto_t0/pro_h0)
         alef_0 = pom_0 - width/un2 ; arig_0 = pom_0 + width/un2
         alef=-arig_0 ;arig=-alef_0
         i_str = (((alef-his_min_big)*num_his_big) &
                 /(his_max_big-his_min_big))
         i_hi  = (((arig-his_min_big)*num_his_big) &
                 /(his_max_big-his_min_big))
         ! Avoiding outside points ---------------------------------------
         IF(i_hi<0)THEN;                    CYCLE
         ELSE IF(i_str>num_his_big)THEN;  CYCLE
         ELSE;
               IF(i_str<0)THEN
                    i_str=-1;
                   alef=om_grid_big(0)-sh_his_big
               ENDIF
               IF(i_hi>num_his_big)THEN
                    i_hi=num_his_big+1;
                   arig=om_grid_big(num_his)+sh_his_big
               ENDIF
         ENDIF
         ! Distributing weight to histogram cells........................................
         IF(i_hi.eq.i_str) THEN
            hi_flo_big(i_str)=hi_flo_big(i_str)+ &
                             pro_h0*(width/sh_his_big)
         ELSE IF(i_hi.eq.i_str+1) THEN
            zyt_l=(om_grid_big(i_str+1)-alef)/sh_his_big
            zyt_r=(arig-om_grid_big(i_hi))/sh_his_big
            IF(zyt_l>0.0d0) &
                hi_flo_big(i_str)=hi_flo_big(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0) &
                hi_flo_big(i_hi)=hi_flo_big(i_hi)+pro_h0*zyt_r
         ELSE
            zyt_l=(om_grid_big(i_str+1)-alef)/sh_his_big
            zyt_r=(arig-om_grid_big(i_hi))/sh_his_big
            IF(zyt_l>0.0d0) &
                hi_flo_big(i_str)=hi_flo_big(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0) &
                hi_flo_big(i_hi)=hi_flo_big(i_hi)+pro_h0*zyt_r
            DO ifw=i_str+1,i_hi-1
               hi_flo_big(ifw)=hi_flo_big(ifw)+pro_h0
            ENDDO
         ENDIF
      ENDDO
      ENDIF mirror1; !Mirrroring if for OC
! Big spectrum abowe: broad histogram

      miva=MINVAL(hi_flo_big(0:num_his_big))
      IF(miva<0.0d0)THEN
         PRINT*,"BIG:",miva; !STOP
      ENDIF


! First anzac
      i_anz = ((om_anz_b-his_min)*num_his)/(his_max-his_min)
      hi_flo(i_anz) = hi_flo(i_anz) + (z_anz_b/sh_his)

!      PRINT*,"Ends histogram"

      END SUBROUTINE HISTO_FORM
!....................................................................

!--------------------------------------------------------------------
!     Writing histogram to file for loop
!--------------------------------------------------------------------
      SUBROUTINE LOOP_WRITE
      USE global_control ; USE ext_control_data
      USE time_data ;
      IMPLICIT NONE

      OPEN(4,FILE='his_flo.dat')
      DO i=0,num_his ;
          WRITE(4,*)om_grid(i)+sh_his/un2 , hi_flo(i)
      ENDDO
      CLOSE(4)

      OPEN(4,FILE='his_flo_big.dat')
      DO i=0,num_his_big ;
          WRITE(4,*)om_grid_big(i)+sh_his_big/un2 , hi_flo_big(i)
      ENDDO
      CLOSE(4)

!KERNEL_GDE      
      OPEN(4,FILE='dev_flo.dat')
      SELECT CASE(kernel_type)
         CASE(0,1,2,3)
            DO i=1,nt ;
               WRITE(4,*) ta(i),deviation(i) ;
            ENDDO
         CASE(4,5)
            DO i=1,nt ;
               WRITE(4,*)i,deviation(i) ;
            ENDDO
            OPEN(9,FILE='dev_flo_im.dat')
            DO i=1,nt ;
               WRITE(9,*)i,deviation_im(i) ;
            ENDDO
            CLOSE(9)
         CASE(6)
            DO i=1,nt_d2 ;
               WRITE(4,*)i,deviation(i) ;
            ENDDO
            OPEN(9,FILE='dev_flo_im.dat')
            DO i=1,nt_d2 ;
               WRITE(9,*)i,deviation_im(i) ;
            ENDDO
            CLOSE(9)
         CASE(7)
            DO i=1,nt_d2 ;
               WRITE(4,*)i,deviation(i) ;
            ENDDO
            OPEN(9,FILE='dev_flo_im.dat')
            DO i=1,nt_d2 ;
               WRITE(9,*)i,deviation_im(i) ;
            ENDDO
            CLOSE(9)
            OPEN(9,FILE='dev_flo_imatau.dat')
            DO i=1,nt_imag ;
               WRITE(9,*)i,deviation_imatau(i) ;
            ENDDO
            CLOSE(9)
       END SELECT       
      CLOSE(4)

      !PRINT*,"WRITTEN"; STOP
      
      END SUBROUTINE loop_write
!....................................................................

!--------------------------------------------------------------------
! Wrighting result for ONE ATTEMPT
!--------------------------------------------------------------------
      SUBROUTINE ATTEMPT_WRITE(nashli)
      USE global_control;
      USE ext_control_data; USE float_configuration;
      IMPLICIT NONE
      LOGICAL,INTENT(IN) :: nashli
      LOGICAL :: Udachi
      REAL*8,DIMENSION(8) :: ahh
      

! Doing only id attempt is successfull
      IfAttemptOK: IF(nashli)THEN

          i_glo_suc=i_glo_suc+1
          PRINT*,"Now initial_k :",initial_k

          po_of(i_glo_suc,1)=z_best;
          po_of(i_glo_suc,2)=max_deviation
          po_of(i_glo_suc,3)=ave_deviation;
          po_of(i_glo_suc,4)=om_anz_b
          po_of(i_glo_suc,5)=z_anz_b
          po_of(i_glo_suc,6)=kurik
          po_of(i_glo_suc,7)=initial_k
          po_of(i_glo_suc,8)=kappa
          nm_of(i_glo_suc)=nmnmb

          hi_glob(0:num_his)=hi_glob(0:num_his)/num_stat
          hi_glob_big(0:num_his_big)=hi_glob_big(0:num_his_big)/num_stat

          IF(refinement==0) THEN
            OPEN(UNIT=4,       FILE='glo_spec.dat' ,ACCESS='direct', &
                RECL=rec_len, FORM='unformatted')
          ELSE
            OPEN(UNIT=4,       FILE='ref_spec.dat' ,ACCESS='direct', &
                RECL=rec_len, FORM='unformatted')
          ENDIF
          WRITE(4,REC=i_glo_suc)hi_glob(0:num_his);
          CLOSE(4)

          IF(refinement==0) THEN
            OPEN(UNIT=4,   FILE='glo_spec_big.dat' ,ACCESS='direct', &
                RECL=rec_len_big, FORM='unformatted')
          ELSE
            OPEN(UNIT=4,  FILE='ref_spec_big.dat' ,ACCESS='direct', &
                RECL=rec_len_big, FORM='unformatted')
          ENDIF
          WRITE(4,REC=i_glo_suc)hi_glob_big(0:num_his_big);
          CLOSE(4)

          nmnm = nmnmb ;               om_0(1:nmnm)=om_b(1:nmnm)
          to_t0(1:nmnm)=to_tb(1:nmnm); ro_h0(1:nmnm)=ro_hb(1:nmnm)
          om_anz_0 = om_anz_b ; z_anz_0 = z_anz_b               !anzac_1 float
          CALL vert_slice(Udachi)
          slicing_success: IF(Udachi)THEN;
              PRINT*,"Smooth histo attempted"
             kernel: IF(kernel_type<8)THEN; !for kernel >=7 no CC
                 IF(refinement/=1)THEN
                    !CALL Data_to_Kol
                 ENDIF
             ELSE kernel
                    PAUSE"No =8 and larger kernels"
             ENDIF kernel 
          ELSE slicing_success 
                ! PRINT*,"*************** UDACHI NET NET NET **********"
          ENDIF slicing_success
          CALL HISTO_FORM(.FALSE.)
          hi_flo_kol(0:num_his)=hi_flo(0:num_his)
          IF(refinement==0) THEN
            OPEN(UNIT=4,  FILE='glo_spec_kol.dat' ,ACCESS='direct', &
                RECL=rec_len, FORM='unformatted')
          ELSE
            OPEN(UNIT=4,  FILE='ref_spec_kol.dat' ,ACCESS='direct', &
                RECL=rec_len, FORM='unformatted')
          ENDIF
          WRITE(4,REC=i_glo_suc)hi_flo_kol(0:num_his);
          CLOSE(4)

          IF(refinement==0) THEN
            OPEN(UNIT=3,  FILE='glo_conf.dat' ,ACCESS='direct', &
                RECL=conf_new, FORM='unformatted')
          ELSE
            OPEN(UNIT=3, FILE='ref_conf.dat' ,ACCESS='direct', &
                RECL=conf_new, FORM='unformatted')
          ENDIF
          WRITE(3,REC=i_glo_suc)nmnmb, &
            om_b(1:nmnmb),to_tb(1:nmnmb),ro_hb(1:nmnmb);
          CLOSE(3)

          IF(refinement==0)THEN;
              OPEN(UNIT=4,FILE='glo_each.dat')
          ELSE;
              OPEN(UNIT=4,FILE='ref_each.dat')
          ENDIF
          DO i=1,i_glo_suc;
             ahh(1:8)=po_of(i,1:8)
             WRITE(4,'(8(ES18.11,1X),I5)')ahh(1:8),nm_of(i);
          ENDDO
          CLOSE(4)

      ENDIF IfAttemptOK

      IF(refinement==0)THEN;
          OPEN(UNIT=4,FILE='glo_run.dat')
      ELSE;
          OPEN(UNIT=4,FILE='ref_run.dat')
      ENDIF;
      WRITE(4,*)k,i_glo_run,i_glo_suc;
      CLOSE(4)
      
      OPEN(UNIT=4,FILE="pomog.dat")
          WRITE(4,*)i_pomog
          DO i=1,i_pomog
              WRITE(4,*)i,Pomog(i,1),Pomog(i,2) 
          ENDDO
      CLOSE(4)


      END SUBROUTINE ATTEMPT_WRITE
!....................................................................

!--------------------------------------------------------------------
! Calculating the reverse error function for given gc(1:nt)
!--------------------------------------------------------------------
      REAL*8 FUNCTION E_ES()
      USE time_data; USE global_control;
      USE ext_control_data; USE proc_par;
      IMPLICIT NONE
      REAL*8 :: dur_1,dur_2,abc

      e_es=0.0d0
      e_es_compl=0.0d0
      e_es_image=0.0d0
      
      DO i=1,nt

!KERNEL_GDE
          SELECT CASE(kernel_type)
         CASE(0, 1, 2, 3)
            dur_1 = ( gc(i) - gr(i) ) ** 2
            dur_2 = ( gr(i) * sigma(i) ) ** 2
            !PRINT*,gc(i),gr(i)
         CASE(4, 5)
            dur_1 = ( ABS(gc_MA(i)-G_input(i)) ) ** 2
            dur_2 = ( ABS(G_input(i)) * sigma(i) ) ** 2
         CASE(6)
            dur_1 = ( gc(i) - gr(i) ) ** 2
            dur_2 = ( sigma(i) ) ** 2
         CASE(7)
            dur_1 = ( gc(i) - gr(i) ) ** 2
            dur_2 = ( sigma(i) ) ** 2
         CASE DEFAULT
             STOP"CASE for ES() not present"
         END SELECT

         abc = dur_1/dur_2
         
         SELECT CASE(kernel_type)
             CASE(0,1,2,3,4,5,6)
                  e_es = e_es + abc
             CASE(7)
                 IF(i <= nt_compl)THEN
                     e_es_compl = e_es_compl + abc 
                 ELSE    
                     e_es_image = e_es_image + abc
                 ENDIF    
             END SELECT     
         
      ENDDO

      object_complex = e_es_compl / nt_compl
      object_imaginary = e_es_image / nt_imag
      
      SELECT CASE(kernel_type)
          CASE(0,1,2,3,4,5,6)    
               e_es = e_es / (nt)
          CASE(7)  
               e_es = ( e_es_compl + e_es_image ) / (nt) 
      END SELECT
      e_es =  un1  / (e_es + 1.0d-100)

      END FUNCTION E_ES
!....................................................................

!--------------------------------------------------------------------
! Calculating the deviation function for float configuration
! Kernel_type =
!     0  -  exp(-\omega \tau)
!     1  -  optical conductivity finite T
!     2  -  Fermi finite T imaginary time
!     3  -  Bose  finite T imaginary time symmetrized
!     4  -  Fermi finite T Matsubara
!     5  -  Bose  finite T Matsubara
!     6  -  exp(-\omega \tau exp(i\phi)) -slanted \tau --> \tau exp(i\phi)    
!     7  -  exp(-\omega \tau exp(i\phi)) -slanted \tau and   exp(-\omega \tau) imag tau  
!--------------------------------------------------------------------
      REAL*8 FUNCTION &
         ANN(omomanz,zzzanz,om,ro_h,ro_t,anorma,nom,global,num_at)
      USE time_data ; USE global_control;
      USE proc_par ; USE ext_control_data; USE tabul_dat;
      IMPLICIT NONE

      REAL*8,EXTERNAL :: E_ES, AKKA, EX
      LOGICAL,EXTERNAL ::  HERA

      REAL*8,DIMENSION(nom+1),INTENT(IN) :: om,ro_h,ro_t
      REAL*8,INTENT(IN)                    :: zzzanz,omomanz,anorma
      INTEGER,INTENT(IN)                   :: nom,num_at       !Num of frequencies and case number
      LOGICAL,INTENT(IN)                   :: global           ! Recalculate only changes if FALSE

      LOGICAL :: guki
      REAL*8,DIMENSION(nom) :: odl,odr
      REAL*8 :: hei, omp, halfwid, akun, aleh, aler, awl, awr, cuti
      INTEGER :: n
      COMPLEX*16 :: akun_MA

      guki=global
!      guki=.TRUE.

 !prepare parameters for all frequencies if recalculate all
      IF(guki)THEN; !prepare parameters for all frequencies
         DO n = 1 , nom
            hei=ro_h(n);  omp=om(n); halfwid=(ro_t(n)/hei)/un2
            odl(n) = omp - halfwid  ;  odr(n) = omp + halfwid
            IF(HERA(odl(n),odr(n)))GOTO 999
         ENDDO
      ENDIF

!KERNEL_GDE      
      kernel_kind: SELECT CASE(kernel_type) !Selecting kernel type

      CASE(0) kernel_kind  ! T=0 exp kernel

          IF(guki)THEN; !recalculate all

             DO i=1,nt
                 IF(ABS(ta(i))>1.0d-20)THEN
                    akun=0.0
                    DO n=1,nom
                       awl=ta(i)*odl(n) ;   awr=ta(i)*odr(n)
                       aleh=EX(-awl);      aler=EX(-awr)
                       akun = akun + ro_h(n)*(aleh-aler)/ta(i)
                    ENDDO
                    gc(i) = akun + zzzanz*EX(-omomanz*ta(i)) ! ANZAC is taken
                 ELSE
                    gc(i) = SUM(ro_t(1:nom)) + zzzanz
                 ENDIF
             ENDDO
             gc_global(1:nt)=gc(1:nt)

          ELSE; !recalculate only changed

             gc(1:nt)=gc_global(1:nt)
             IF(chf1(1)/=0) &
               CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             IF(chf2(1)/=0) &
               CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)

          ENDIF

          gc_at(num_at,1:nt)=gc(1:nt)

      CASE(1) kernel_kind ! kernel_kind OC T/=0 kernel

          IF(guki)THEN; !recalculate all

              DO i=1,nt
                 akun=0.0
                 DO n=1,nom
                    akun = akun + ro_h(n) * AKKA(i, odr(n), odl(n))
                    akun = akun + ro_h(n) * AKKA(i,-odl(n),-odr(n))
                 ENDDO
                 gc(i) = akun  ! No ANZAC is taken into account
              ENDDO
              gc_global(1:nt)=gc(1:nt)

          ELSE; !recalculate only changed

             gc(1:nt)=gc_global(1:nt)
             IF(chf1(1)/=0)  &
               CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             IF(chf2(1)/=0)  &
               CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)

          ENDIF

          gc_at(num_at,1:nt)=gc(1:nt)

      CASE(2, 3) kernel_kind ! kernel for imaginary time Fermi and Bose

          IF(guki)THEN; !recalculate all

              DO i=1,nt
                 akun=0.0
                 DO n=1,nom
                    akun = akun + ro_h(n) * AKKA(i, odr(n), odl(n))
                 ENDDO
                 gc(i) = akun  ! No ANZAC is taken into account
              ENDDO
              gc_global(1:nt)=gc(1:nt)

          ELSE; !recalculate only changed

             gc(1:nt)=gc_global(1:nt)
             IF(chf1(1)/=0) &
               CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             IF(chf2(1)/=0) &
               CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)

          ENDIF

         gc_at(num_at,1:nt)=gc(1:nt)

      CASE(4, 5) kernel_kind ! kernel for Matsubara Fermi and Bose

         IF(guki)THEN; !recalculate all
             DO i=1,nt               ! loop over the matsubaras
             akun_MA=CMPLX(0.0d0,0.0d0)
             DO n=1,nom           ! loop over rectangles
              akun_MA = akun_MA + ro_h(n) * &
                    LOG( (odr(n)-Om_input(i)) / (odl(n)-Om_input(i)) )
             ENDDO
             gc_MA(i) = akun_MA ! No anzac is taken into account
            ENDDO
            gc_global_MA(1:nt)=gc_MA(1:nt)

         ELSE; !recalculate only changed

            gc_MA(1:nt)=gc_global_MA(1:nt)
            IF(chf1(1)/=0) &
              CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
            IF(chf2(1)/=0) &
              CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)

         ENDIF

         gc_at_MA(num_at,1:nt)=gc_MA(1:nt)
         
      CASE(6) kernel_kind ! Slated tau kernel t = \tau * exp(i\phi)    

          IF(guki)THEN; !recalculate all

              DO i=1,nt
                 akun=0.0
                 DO n=1,nom
                    akun = akun + ro_h(n) * AKKA(i, odr(n), odl(n))
                 ENDDO
                 cuti = omomanz*ta(i)
                 IF(i<=nt_d2)THEN ! Adding anzac which is not in AKKA
                     gc(i) = akun + & 
                     zzzanz * EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                 ELSE
                     gc(i) = akun - & 
                     zzzanz * EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                 ENDIF    
              ENDDO
              gc_global(1:nt)=gc(1:nt)

          ELSE; !recalculate only changed

             gc(1:nt)=gc_global(1:nt)
             IF(chf1(1)/=0) &
               CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             IF(chf2(1)/=0) &
               CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             
          ENDIF 
          
        gc_at(num_at,1:nt)=gc(1:nt)          
             
      CASE(7) kernel_kind ! Slated tau kernel t = \tau * exp(i\phi)    

          IF(guki)THEN; !recalculate all

              DO i=1,nt
                 akun=0.0
                 DO n=1,nom
                    akun = akun + ro_h(n) * AKKA(i, odr(n), odl(n))
                 ENDDO
                 cuti = omomanz*ta(i)
                 IF(i<=nt_d2)THEN ! Adding anzac which is not in AKKA
                     gc(i) = akun + & 
                     zzzanz * EX(-cuti*cos(phi))*cos(cuti*sin(phi))
                 ELSE IF(i>nt_d2 .AND. i<=nt_compl)THEN
                     gc(i) = akun - & 
                     zzzanz * EX(-cuti*cos(phi))*sin(cuti*sin(phi))
                 ELSE IF(i>nt_compl .AND. i<=nt)THEN
                     gc(i) = akun + & 
                     zzzanz * EX(-cuti)                     
                 ELSE
                     STOP"Nu i kak s etim i?"
                 ENDIF    
              ENDDO
              gc_global(1:nt)=gc(1:nt)

          ELSE; !recalculate only changed

             gc(1:nt)=gc_global(1:nt)
             IF(chf1(1)/=0) &
               CALL UPDATE(chf1,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             IF(chf2(1)/=0) &
               CALL UPDATE(chf2,om,ro_h,ro_t,anorma,nom,omomanz,zzzanz)
             
          ENDIF 
          
        gc_at(num_at,1:nt)=gc(1:nt)          
             
      CASE DEFAULT kernel_kind

          STOP"THE KERNEL MUST BE SELECTD!!!!!!!!!!!!!!!!!"

      END SELECT kernel_kind

      ann =  E_ES()
      
      RETURN

999   CONTINUE
      ann=1.0d-50

      END FUNCTION ANN
!....................................................................

!--------------------------------------------------------------------
! Calculating the update of the free frequency
!                          num=chf(1)
! with the processes:
!              a) chf(2) =  0  -- change parameters
!              b) chf(2) = -1  -- delete
!              c) chf(2) = +1 -- born
!              d) chf(2) = +2 -- recalculate anzac
! Note: If chf(1)=0, the subroutine is inactive,
!          If chf(1)/=0, the number of free-spectrum
!                             frequency to operate is
!                             transmitted to subroutine.
!--------------------------------------------------------------------
      SUBROUTINE UPDATE(chf,om,ro_h,ro_t,anorma,nom,om_anz_g,z_anz_g)
      USE time_data; USE global_control; USE ext_control_data;
      USE float_configuration; USE proc_par;
      IMPLICIT NONE

      LOGICAL,EXTERNAL :: HERA
      REAL*8,EXTERNAL :: EX, AKKA

      REAL*8,INTENT(IN)                    :: anorma,om_anz_g,z_anz_g
      REAL*8,DIMENSION(nom+1),INTENT(IN) :: om,ro_h,ro_t
      INTEGER,DIMENSION(2),INTENT(IN)      :: chf
      INTEGER,INTENT(IN)                   :: nom

      REAL*8, DIMENSION(2) :: odl,odr
      REAL*8 :: hei,omp,halfwid,awl,awr,akun,aleh,aler
      INTEGER :: num,nok

! Set frequency parameters: final if altered / new if added / existing if removed
         IF(chf(2)/=2)THEN
            num=chf(1)
            hei=ro_h(num);
            omp=om(num);
            halfwid=(ro_t(num)/hei)/un2
            odl(1) = omp - halfwid  ;  odr(1) = omp + halfwid
            IF(HERA(odl(1),odr(1)))THEN
                PRINT*,"Bad parameters of new frequency"
                PRINT*,hei,halfwid,omp
                RETURN
            ENDIF
         ENDIF

! Select type of update
      type_of_update: SELECT CASE(chf(2)) ! Selecting type of update

      CASE(0) type_of_update !Change the characteristic of the frequency

      ! Initial frequency if altered
         hei=ro_h0(num); omp=om_0(num); halfwid=(to_t0(num)/hei)/un2
         odl(2) = omp - halfwid  ;  odr(2) = omp + halfwid
         IF(HERA(odl(2),odr(2)))RETURN

!KERNEL_GDE
         kernel_kind: SELECT CASE(kernel_type) !Selecting kernel type
         CASE(0) kernel_kind  ! T=0 exp kernel
            DO i=1,nt
               IF(ABS(ta(i))>1.0d-20)THEN
               DO nok=1,2
                  awl=ta(i)*odl(nok)  ;   awr=ta(i)*odr(nok)
                  aleh=EX(-awl) ; aler=EX(-awr)
                  IF(nok==1)THEN
                     gc(i) = gc(i) + ro_h(num)*(aleh-aler)/ta(i)
                  ELSE IF(nok==2)THEN
                     gc(i) = gc(i) - ro_h0(num)*(aleh-aler)/ta(i)
                  ENDIF
               ENDDO
               ENDIF
            ENDDO
         CASE(1) kernel_kind ! Optical conductivity
                ! IF(num==34 .AND. nom==72)THEN
                ! PRINT*,num,nom,odr(1),odl(1)
                ! PRINT*,hei,halfwid
                ! ENDIF
            DO i=1,nt
               DO nok=1,2
                  IF(nok==1)THEN
                     gc(i) = gc(i) &
                    + ro_h(num)*AKKA(i, odr(nok), odl(nok)) &
                    + ro_h(num)*AKKA(i,-odl(nok),-odr(nok))
                  ELSE IF(nok==2)THEN
                     gc(i) = gc(i) &
                    - ro_h0(num)*AKKA(i, odr(nok), odl(nok)) &
                    - ro_h0(num)*AKKA(i,-odl(nok),-odr(nok))
                  ELSE
                     STOP'SUBSTITUTE DELIRION'
                  ENDIF
               ENDDO
            ENDDO
         CASE(2, 3) kernel_kind ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               DO nok=1,2
                  IF(nok==1)THEN
                     gc(i) = gc(i) &
                    + ro_h(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE IF(nok==2)THEN
                     gc(i) = gc(i) &
                    - ro_h0(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE
                     STOP'SUBSTITUTE DELIRION'
                  ENDIF
               ENDDO
            ENDDO
         CASE(4, 5) kernel_kind  ! kernel for Matsubara Fermi and Bose
            DO i=1,nt
               gc_MA(i) = gc_MA(i) + ro_h(num)* &
              LOG( (odr(1)-Om_input(i)) / (odl(1)-Om_input(i)) )
               gc_MA(i) = gc_MA(i) -  ro_h0(num)* &
              LOG( (odr(2)-Om_input(i)) / (odl(2)-Om_input(i)) )
            ENDDO
         CASE(6) kernel_kind ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               DO nok=1,2
                  IF(nok==1)THEN
                     gc(i) = gc(i) &
                    + ro_h(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE IF(nok==2)THEN
                     gc(i) = gc(i) &
                    - ro_h0(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE
                     STOP'SUBSTITUTE DELIRION'
                  ENDIF
               ENDDO
            ENDDO
         CASE(7) kernel_kind ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               DO nok=1,2
                  IF(nok==1)THEN
                     gc(i) = gc(i) &
                    + ro_h(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE IF(nok==2)THEN
                     gc(i) = gc(i) &
                    - ro_h0(num)*AKKA(i, odr(nok), odl(nok))
                  ELSE
                     STOP'SUBSTITUTE DELIRION'
                  ENDIF
               ENDDO
            ENDDO
         END SELECT kernel_kind

      CASE(1) type_of_update !add new frequency

         kernel_kind1: SELECT CASE(kernel_type) !Selecting kernel type
         CASE(0) kernel_kind1  ! T=0 exp kernel
            DO i=1,nt
               IF(ABS(ta(i))>1.0d-20)THEN
               awl=ta(i)*odl(1)  ;   awr=ta(i)*odr(1)
               aleh=EX(-awl) ;   aler=EX(-awr)
               gc(i) = gc(i) + ro_h(num)*(aleh-aler)/ta(i)
               ENDIF
            ENDDO
         CASE(1) kernel_kind1 ! Optical conductivity
            DO i=1,nt
               gc(i) = gc(i) &
                 + ro_h(num)*AKKA(i, odr(1), odl(1)) &
                 + ro_h(num)*AKKA(i,-odl(1),-odr(1))
            ENDDO
         CASE(2, 3) kernel_kind1 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 + ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         CASE(4, 5) kernel_kind1  ! kernel for Matsubara Fermi and Bose
            DO i=1,nt
               gc_MA(i) = gc_MA(i) + ro_h(num)* &
              LOG( (odr(1)-Om_input(i)) / (odl(1)-Om_input(i)) )
            ENDDO
         CASE(6) kernel_kind1 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 + ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         CASE(7) kernel_kind1 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 + ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         END SELECT kernel_kind1

      CASE(-1) type_of_update !remove frequency

         kernel_kind2: SELECT CASE(kernel_type) !Selecting kernel type
         CASE(0) kernel_kind2  ! T=0 exp kernel
            DO i=1,nt
               IF(ABS(ta(i))>1.0d-20)THEN
               awl=ta(i)*odl(1)  ;   awr=ta(i)*odr(1)
               aleh=EX(-awl);  aler=EX(-awr)
               gc(i) = gc(i) - ro_h(num)*(aleh-aler)/ta(i)
               ENDIF
            ENDDO
         CASE(1) kernel_kind2 ! Optical conductivity
             DO i=1,nt
               gc(i) = gc(i) &
                 - ro_h(num)*AKKA(i, odr(1), odl(1)) &
                 - ro_h(num)*AKKA(i,-odl(1),-odr(1))
            ENDDO
         CASE(2, 3) kernel_kind2 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 - ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         CASE(4, 5) kernel_kind2  ! kernel for Matsubara Fermi and Bose
            DO i=1,nt
               gc_MA(i) = gc_MA(i) - ro_h(num)* &
              LOG( (odr(1)-Om_input(i)) / (odl(1)-Om_input(i)) )
            ENDDO
         CASE(6) kernel_kind2 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 - ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         CASE(7) kernel_kind2 ! kernel for imaginary time Fermi and Bose
            DO i=1,nt
               gc(i) = gc(i) &
                 - ro_h(num)*AKKA(i, odr(1), odl(1))
            ENDDO
         END SELECT kernel_kind2

      CASE(2) type_of_update !recalculate anzac_1

         kernel_kind3: SELECT CASE(kernel_type)  !Selecting kernel type
             
         CASE(0) kernel_kind3  ! T=0 exp kernel

            !PRINT*,"INSIDE:",z_anz_g,om_anz_g
            DO i=1,nt
               gc(i) = gc(i) + z_anz_g * EX( -om_anz_g * ta(i) ) &
                                 - z_anz_0 * EX( -om_anz_0 * ta(i) )
            ENDDO

         CASE(6) kernel_kind3  ! T=0 angle complex time kernel

            !PRINT*,"INSIDE:",z_anz_g,om_anz_g
            DO i=1,nt
               IF(i<=nt_d2)THEN 
               gc(i) = gc(i) + &
               z_anz_g*EX(-om_anz_g*ta(i)*cos(phi))*cos(om_anz_g*ta(i)*sin(phi)) &
              -z_anz_0*EX(-om_anz_0*ta(i)*cos(phi))*cos(om_anz_0*ta(i)*sin(phi))
               ELSE
               gc(i) = gc(i) - &
               z_anz_g*EX(-om_anz_g*ta(i)*cos(phi))*sin(om_anz_g*ta(i)*sin(phi)) &
              +z_anz_0*EX(-om_anz_0*ta(i)*cos(phi))*sin(om_anz_0*ta(i)*sin(phi))
               ENDIF    
            ENDDO
            
         CASE(7) kernel_kind3  ! T=0 angle complex time kernel

            !PRINT*,"INSIDE:",z_anz_g,om_anz_g
            DO i=1,nt
               IF(i<=nt_d2)THEN 
               gc(i) = gc(i) + &
               z_anz_g*EX(-om_anz_g*ta(i)*cos(phi))*cos(om_anz_g*ta(i)*sin(phi)) &
              -z_anz_0*EX(-om_anz_0*ta(i)*cos(phi))*cos(om_anz_0*ta(i)*sin(phi))
               ELSE IF(i>nt_d2 .AND. i<=nt_compl)THEN
               gc(i) = gc(i) - &
               z_anz_g*EX(-om_anz_g*ta(i)*cos(phi))*sin(om_anz_g*ta(i)*sin(phi)) &
              +z_anz_0*EX(-om_anz_0*ta(i)*cos(phi))*sin(om_anz_0*ta(i)*sin(phi))
               ELSE IF(i>nt_compl .AND. i<=nt)THEN
               gc(i) = gc(i) + &
               z_anz_g*EX(-om_anz_g*ta(i)) &
              -z_anz_0*EX(-om_anz_0*ta(i))                   
               ENDIF    
            ENDDO
            
         CASE DEFAULT kernel_kind3
         
            STOP"Impossible anzac for such types of kenel"
            
         END SELECT kernel_kind3

      CASE DEFAULT type_of_update

         STOP'UPDATE DELIRION'

      END SELECT type_of_update

      END SUBROUTINE UPDATE
!....................................................................

!--------------------------------------------------------------------
!     Writing histogram to file for refinement 
!--------------------------------------------------------------------
      SUBROUTINE REF_WRITE
      USE global_control ; USE ext_control_data
      USE time_data ;
      IMPLICIT NONE

      OPEN(4,FILE='his_ref.dat')
      DO i=0,num_his ;
         WRITE(4,*)om_grid(i)+sh_his/un2, hi_flo(i)
      ENDDO
      CLOSE(4)

      OPEN(4,FILE='his_ref_big.dat')
      DO i=0,num_his_big ;
          WRITE(4,*)om_grid_big(i)+sh_his_big/un2, hi_flo_big(i)
      ENDDO
      CLOSE(4)

      OPEN(4,FILE='dev_ref.dat')
      SELECT CASE(kernel_type)
         CASE(0,1,2,3)
            DO i=1,nt ;
               WRITE(4,*) ta(i),deviation(i) ; 
            ENDDO
         CASE(4,5)
            DO i=1,nt ;
               WRITE(4,*)i,deviation(i) ; 
            ENDDO             
            OPEN(9,FILE='dev_ref_im.dat')
            DO i=1,nt ;
               WRITE(9,*)i,deviation_im(i) ;
            ENDDO
            CLOSE(9)
      END SELECT       
      CLOSE(4)

      END SUBROUTINE REF_WRITE
!....................................................................

